$(document).ready(function() {
    $('.radio-group .radio').click(function() {
        $('.selected .fa').removeClass('fa-check');
        $('.radio').removeClass('selected');
        $(this).addClass('selected');
    });
});

$('#login').hide();
$('#port').hide();
$('#load').hide();

var index = 0;

function avancar() {

    if (index == 0) {

        if (typeof $("input[name=template]:checked").val() === "undefined") {

            Swal.fire({
                icon: 'error',
                title: 'Oops...',
                text: 'Você precisa selecionar pelo menos um template!',
            })
        } else {

            $('#template').hide();
            $('#login').show();

            index++;
        }

    } else if (index == 1) {
        if (!$('#username').val() || !$('#password').val()) {

            Swal.fire({
                icon: 'error',
                title: 'Oops...',
                text: 'Informe o usuário e senha enviados para você no e-mail de dados de acesso',
            })
        } else {

            $('#login').hide();
            $('#port').show();

            index++;
        }

    } else if (index == 2) {

        if (!$('#portvalue').val()) {

            Swal.fire({
                icon: 'error',
                title: 'Oops...',
                text: 'Informe a porta do seu Stream, ela foi enviada pra você no e-mail',
            })
        } else {

            $('#port').hide();
            $('#load').show();

            $.ajax({

                type: 'POST',
                url: "index.php",
                data: {
                    username: $('#username').val(),
                    password: $('#password').val(),
                    port: $('#portvalue').val(),
                    template: $("input[name=template]:checked").val()
                },

                enctype: 'multipart/form-data',

                success: function(data) {

                    console.log(data);

                    data = jQuery.parseJSON(data);

                    if (data['success'] == true) {

                        Swal.fire({
                            icon: 'success',
                            title: 'Concluído',
                            text: 'Seu WebSite foi configurado com sucesso!',
                        }).then((result) => {
                            window.location = "/";
                        })

                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Oops...',
                            text: data['message'],
                        }).then((result) => {
                            document.location.reload(true);
                        })
                    }

                },

                error: function(data) {
                    // console.log(data);

                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: 'Algo deu errado, entre em contato com o suporte',
                    }).then((result) => {
                        window.location = "/";
                    })
                    console.log('Erro no Ajax!');

                }

            });

            index++;
        }
    }

}

function voltar() {
    index--;
    if (index == 0) {

        $('#template').show();
        $('#login').hide();
        $('#port').hide();


    } else if (index == 1) {
        $('#template').hide();
        $('#login').show();
        $('#port').hide();

    } else if (index == 2) {
        $('#template').hide();
        $('#login').hide();
        $('#port').show();
    }
}