<?php

class api{
    function create_database($username, $password){

        require_once('xmlapi.php');

        $opts = [
            "userName" => $username, //+++ Replace UserUserName
            "password" => $password, //+++ Replace UserPassword
            "dbName" => "radio", //+++ Replace DatabasePassword
            "dbUserName" => "radio", //+++ Replace dbUserName  
            "dbPassword" => $this->randomPassword(), //+++ Replace dbPassword
        ];

        $xmlapi = new xmlapi("127.0.0.1");
        $xmlapi->set_port(2083);
        $xmlapi->password_auth($opts['userName'], $opts['password']);
        $xmlapi->set_output('json');

        $cpaneluser = $opts['userName'];
        $databasename = $opts['dbName'];
        $databaseuser = $opts['dbUserName'];
        $databasepass = $opts['dbPassword'];

        // database creation
        $createdb = json_decode($xmlapi->api1_query($cpaneluser, "Mysql", "adddb", array(
            $databasename
        )));
        
        
        // user creation
        $usr = json_decode($xmlapi->api1_query($cpaneluser, "Mysql", "adduser", array(
            $databaseuser,
            $databasepass
        )));

        // adds user to database
        $addusr = json_decode($xmlapi->api1_query($cpaneluser, "Mysql", "adduserdb", array(
            $cpaneluser . "_" . $databasename,
            $cpaneluser . "_" . $databaseuser,
            'all'
        )));

        
        if($createdb){
            $createdb = true;
        }else{
            $createdb = false;
        }

        if($usr){
            $usr = true;
        }else{
            $usr = false;
        }
        
        if($addusr){
            $addusr = true;
        }else{
            $addusr = false;
        }


        if($createdb && $usr && $addusr){
            return array(

                'error' => false,
                'text' => 'Banco de dados criado',
                'dbuser' =>  $cpaneluser . "_" .$databaseuser,
                'dbname' =>  $cpaneluser . "_" .$databasename,
                'dbpass' => $databasepass
    
            );
        }else{
            return array(

                'error' => true,
                'text' => 'Falhou ao criar banco de dados'
    
            );
        }
    }

    function delete_database($username, $password){
        
        require_once('xmlapi.php');

        $opts = [
            "userName" => $username, //+++ Replace UserUserName
            "password" => $password, //+++ Replace UserPassword
            "dbName" => "radio", //+++ Replace DatabasePassword
            "dbUserName" => "radio", //+++ Replace dbUserName
        ];

        $xmlapi = new xmlapi("127.0.0.1");
        $xmlapi->set_port(2083);
        $xmlapi->password_auth($opts['userName'], $opts['password']);
        $xmlapi->set_output('json');

        $cpaneluser = $opts['userName'];
        $databasename = $opts['userName'].'_'.$opts['dbName'];
        $databaseuser = $opts['userName'].'_'.$opts['dbUserName'];

        // delete database
        $createdb = json_decode($xmlapi->api1_query($cpaneluser, "Mysql", "deldb", array(
            $databasename
        )));
        // delete user
        $usr = json_decode($xmlapi->api1_query($cpaneluser, "Mysql", "deluser", array(
            $databaseuser
        )));


        return array(

            'error' => false,
            'text' => $createdb

        );


        if($createdb->preevent == 1 && $createdb->event == 1 && $createdb->postevent == 1){
            $createdb = true;
        }else{
            $createdb = false;
        }

        if($usr->preevent == 1 && $usr->event == 1 && $usr->postevent == 1){
            $usr = true;
        }else{
            $usr = false;
        }

        if($createdb && $usr){
            return array(

                'error' => false,
                'text' => 'Banco de dados deletado'
    
            );
        }else{
            return array(

                'error' => true,
                'text' => 'Falhou ao deletar banco de dados'
    
            );
        }

    }

    function check_user($username, $password){

        require_once('xmlapi.php');

        $opts = [
            "userName" => $username, //+++ Replace UserUserName
            "password" => $password, //+++ Replace UserPassword
        ];

        $xmlapi = new xmlapi("127.0.0.1");
        $xmlapi->set_port(2083);
        $xmlapi->password_auth($opts['userName'], $opts['password']);
        $xmlapi->set_output('json');

        $oResult = json_decode($xmlapi->api2_query($opts['userName'], 'MysqlFE', 'listdbs'));

        if($oResult->cpanelresult->event){
            return array(

                'success' => true,
                'message' => 'Autenticado com sucesso'

            );
        }else{
            return array(

                'success' => false,
                'message' => 'Falha ao autenticar'

            );

        }

    }

    function randomPassword(){

        $alphabet = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890!@#$%¨&*()';

        $pass = array(); //remember to declare $pass as an array

        $alphaLength = strlen($alphabet) - 1; //put the length -1 in cache

        for ($i = 0; $i < 8; $i++) {

            $n = rand(0, $alphaLength);

            $pass[] = $alphabet[$n];

        }

        return '%4e'.dechex(time()).'@#$'; //turn the array into a string

    }
}