<?php

namespace Model;

// usage:
//include 'detectControlPanel';
//$object = new \model\detectControlPanel();
//$result = $object->getDetect();
//var_dump($result);

class detectControlPanel
{
    public $debug = false;
    protected $detect = array();
    
    public function getDetect()
    {
        return $this->detect;
    }
    
    public function __construct($debug = false)
    {
        $this->run();
        $this->debug = $debug;
        $this->debug($this->detect);
    }
    
    public function run()
    {
        $this->detect['cpanel'] = $this->isCpanel();
        $this->detect['virtualmin'] = $this->isVirtualmin();
        $this->detect['plesk'] = $this->isPlesk();
        $this->detect['directadmin'] = $this->isDirectadmin();
        return $this->detect;
    }
    
    private function isCpanel()
    {
        try {
            $this->telnet('localhost', 2082);
            return true;
        } catch (\Exception $ex) {
            $this->debug($ex);
            return false;
        }
    }
    
    private function isVirtualmin()
    {
        try {
            $this->telnet('localhost', 10000);
            return true;
        } catch (\Exception $ex) {
            $this->debug($ex);
            return false;
        }
    }
    
    private function isDirectadmin()
    {
        try {
            $this->telnet('localhost', 2222);
            return true;
        } catch (\Exception $ex) {
            $this->debug($ex);
            return false;
        }
    }
    
    private function isPlesk()
    {
        try {
            $this->telnet('localhost', 8443);
            return true;
        } catch (\Exception $ex) {
            $this->debug($ex);
            return false;
        }
    }
    
    private function debug($input)
    {
        if ($this->debug == true) {
            if (gettype($input) == 'string') {
                echo '<br>' . "\n";
                echo $input;
                echo '<br>' . "\n";
            } elseif (gettype($input) == 'array') {
                echo '<pre>' . "\n";
                print_r($input);
                echo '</pre>' . "\n";
            } elseif (gettype($input) == 'object' && get_class($input) == 'Exception') {
                echo '<pre>' . "\n";
                echo $input->getMessage();
                echo '</pre>' . "\n";
            } else {
                var_dump($input);
            }
        }
    }
    
    private function telnet($hostname, $port)
    {
        if (!$hostname)
            throw new \Exception("empty host name");
        if (!$port)
            throw new \Exception("empty port number");
        $ipAddress = gethostbyname($hostname);
        $link = @fsockopen($ipAddress, $port, $errno, $error);
        if ($error) {
            throw new \Exception($error, $errno);
        }
        if ($link) {
            return true;
        }
        return false;
    }
}