<?php 
  include 'inc/init.php';

  if (isset($_POST['enviar'])) {
    $filename = "admin/data/recados/recadosfile.txt";

    if ($_SESSION['captcha'] == $_POST['captcha']) {

      $nome = $_POST['nome'];
      $cidade = $_POST['cidade'];
      $recado = $_POST['recado'];

      $_SESSION['nome_mural'] = $_POST['nome'];
      $_SESSION['cidade_mural'] = $_POST['cidade'];

      if (!empty($_SESSION['avatar_mural'])) {
        $avatar = $_SESSION['avatar_mural'];
      }else{
        $avatar = '';
      }

      $width  = 85;
      $height = 85;


      if(!empty($_FILES['avatar']['tmp_name'])) {

        $file = $_FILES['avatar']['tmp_name']; 
        $sourceProperties = getimagesize($file);
        $fileNewName = time();
        $folderPath = "uploads/avatar/";
        $ext = pathinfo($_FILES['avatar']['name'], PATHINFO_EXTENSION);
        $imageType = $sourceProperties[2];

        switch ($imageType) {
            case IMAGETYPE_PNG:
                $imageResourceId = imagecreatefrompng($file); 
                $targetLayer = BS_imageResize($imageResourceId,$sourceProperties[0],$sourceProperties[1],$width,$height);
                imagepng($targetLayer,$folderPath. $fileNewName .'.'. $ext);
                $avatar = $fileNewName .'.'. $ext;
                $_SESSION['avatar_mural'] = $fileNewName .'.'. $ext;
                break;
            case IMAGETYPE_GIF:
                $imageResourceId = imagecreatefromgif($file); 
                $targetLayer = BS_imageResize($imageResourceId,$sourceProperties[0],$sourceProperties[1],$width,$height);
                imagegif($targetLayer,$folderPath. $fileNewName .'.'. $ext);
                $avatar = $fileNewName .'.'. $ext;
                $_SESSION['avatar_mural'] = $fileNewName .'.'. $ext;
                break;
            case IMAGETYPE_JPEG:
                $imageResourceId = imagecreatefromjpeg($file); 
                $targetLayer = BS_imageResize($imageResourceId,$sourceProperties[0],$sourceProperties[1],$width,$height);
                imagejpeg($targetLayer,$folderPath. $fileNewName .'.'. $ext);
                $avatar = $fileNewName .'.'. $ext;
                $_SESSION['avatar_mural'] = $fileNewName .'.'. $ext;
                break;
            default:
                header("Location: /mural");
                break;
        }
        
      }

      $fp   = fopen($filename,"r") or die($lang_erro_leitura); 
      $data = @fread($fp, filesize($filename));
      fclose($fp);

      $line = explode("\n", $data);
      $no_of_posts = count($line)-1;

      for ($i=0; $i<$no_of_posts; $i++) {
        $blog = explode("|", $line[$i]);
        $posts[$i] = $blog[0];
      }

      if(count($posts) > 0) {
        $no_of_posts = max($posts)+1;
      } else {
        $no_of_posts = 1;
      }

      $nome = htmlspecialchars(trim(stripslashes($nome)), ENT_QUOTES, "UTF-8");
      $cidade = htmlspecialchars(trim(stripslashes($cidade)), ENT_QUOTES, "UTF-8");
      $recado = htmlspecialchars(trim(stripslashes(preg_replace('/[\n|\r|\n\r|\r\n]{2,}/',' ', $recado ))), ENT_QUOTES, "UTF-8");

      $postdate = date('d/m/Y');
      $recado  = str_replace("\n", "", $recado);
      $recado  = str_replace("\r", "", $recado);
      $recado  = str_replace("|", "&brvbar;", $recado);

      $blog = $no_of_posts ."|0|". $postdate ."|". $nome ."|". $cidade ."|". $recado ."|". $avatar ."\n";

      $data = fopen($filename, "a");
      fwrite($data, $blog);
      fclose($data);

      header("Location: /mural");
      die();
    }else{
      $error['captcha'] = $lang_erro_captcha_invalido;
    }
  }

?>
<!DOCTYPE html>
<!--[if IE 8]>         <html class="no-js lt-ie9"> <![endif]-->
<!--[if gt IE 8]><!-->
<html class="no-js">
<!--<![endif]-->

<?php 
  $current_page = (isset($_GET['page']))?' - Página '.$_GET['page'] : '';
  $set_title = $lang_menu_mural.$current_page.' | '. $page_title; 
?>
<?php include 'inc/head.php'; ?>
<body>
<?php include 'inc/player-selector.php'; ?>
<?php include 'inc/menu.php'; ?>

<div id="ajaxArea">
    <div class="pageContentArea">
    <section class="breadcrumb">
       <div class="container">
          <div class="row">
            <div class="col-lg-6 col-md-6 col-sm-6">
              <h1><?php echo $lang_mural_recados; ?></h1>
              <h5><?php echo $lang_menu_mural; ?></h5>
            </div>
          </div>
       </div>
    </section>
    <div class="clearfix"></div>

    <section id="updates">
      <div class="container">
        <div class="row">

          <div class="col-lg-9 col-md-9 col-sm-9">
            <article class="latest-post">

              <br>
              <p class="text-center" style="color: #f00;"><?php if(isset($error['captcha'])){echo $error['captcha'];} ?></p>
              <center><button type="button" class="btn btn-primary btn-lg" data-toggle="modal" data-target="#myModal"><?php echo $lang_deixe_recado; ?></button></center>

                <!-- Modal -->
              <div class="modal fade" id="myModal" role="dialog" style="z-index: 100000;">
                <div class="modal-dialog">

                  <!-- Modal content-->
                  <div class="modal-content">
                    <div class="modal-header">
                      <button type="button" class="close" data-dismiss="modal">&times;</button>
                      <h4 class="modal-title" style="color:#000;"><?php echo $lang_deixe_recado; ?></h4>
                    </div>
                    <div class="modal-body">
                      <section id="contact" >
                        <form action="mural.php" method="post" enctype="multipart/form-data">
                          <center>
                            <img style="width:110px;height:110px" class="thumbnail" id="output" src="<?php if (!empty($_SESSION['avatar_mural'])) {echo 'uploads/avatar/'.$_SESSION['avatar_mural'];}else{echo "assets/img/no_img.gif";} ?>"/>
                            <label class="btn btn-success btn-sm" for="select-file"><?php echo $lang_esc_foto; ?></label>
                            <input id="select-file" style="border: none;display: none" type="file" name="avatar" value="<?php if (!empty($_SESSION['avatar_mural'])) {echo $_SESSION['avatar_mural'];} ?>" accept="image/*" class="default" onchange="loadFile(event)" >
                          </center>
                          <br>

                          <div class="form-group">
                            <input type="text" id="nome" placeholder="<?php echo $lang_nome; ?>" value="<?php if (!empty($_SESSION['nome_mural'])) {echo $_SESSION['nome_mural'];} ?>" name="nome" required />
                          </div>

                          <div class="form-group">
                            <input type="text" id="cidade" placeholder="<?php echo "$lang_cidade / $lang_estado"; ?>"  value="<?php if (!empty($_SESSION['cidade_mural'])) {echo $_SESSION['cidade_mural'];} ?>" name="cidade" required />
                          </div>

                          <div class="form-group">
                            <textarea name="recado" placeholder="<?php echo $lang_recado; ?>" id="message" maxlength="500" required></textarea>
                          </div>
                          
                          <div class="">
                            <img style="width: 100px" src="inc/captcha/captcha.php" alt="código captcha" />
                            <input type="text" name="captcha" id="captcha" required placeholder="<?php echo $lang_captcha; ?> - <?php echo $lang_digite_codigo; ?>" />
                          </div>
                          <center>
                            <button id="submit1" type="submit" name="enviar"><?php echo $lang_enviar; ?></button>
                          </center>
                        </form>
                        <div id="valid-issue" style="display:none;"> <?php echo $lang_info_validas; ?></div>   
                      </section>
                    </div>

                  </div>

                </div>
              </div>
              <br>

              <?php include_once("admin/includes/recados/recados-page.php"); ?>
            </article>
          </div>
          
          <div class="col-lg-3 col-md-3 col-sm-3">
            <div class="banner-app">
              <h1><?php echo $lang_aplicativos; ?></h1>
              <?php include ("admin/bd/$apk_select"); ?>
              <?php include ("admin/bd/$ios_select"); ?>
            </div>
            <br/>

            <h1><?php echo $lang_locutor_ar; ?></h1>
            <span id="no-ar-home"></span>
      
            <?php include 'admin/includes/pedido-page.php'; ?>
            
            <?php include 'inc/top-musica.php'; ?>
        
          </div>
        </div>
      </div>    
    </section>
  </div><!--pageContent-->
</div><!--ajaxwrap-->    
<?php include ("inc/ads.php");  ?>
<?php include ("inc/footer.php");  ?>
<?php include ("inc/scripts.php");  ?>
<script type="text/javascript">
var loadFile = function(event) {
  var output = document.getElementById('output');
  output.src = URL.createObjectURL(event.target.files[0]);
};
</script>
</body>
</html>
