<?php echo $__env->make('admin.header', [
   'elementActive' => 'photos'
], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="content-wrapper">

    <section class="content-header">
      <h1>
      Galeria de Fotos<small>Adicione as fotos da sua Rádio na galeria</small>
      </h1> 
    </section>

    <!-- Main content -->
    <section class="content">
    <div class="row">
        
        <div class="col-xs-12">    		

         <div class="nav-tabs-custom">
            <ul class="nav nav-tabs ">
               <li <?php echo $active == 'photos' || $active == false ? 'class="active"' : ''; ?>  >
                  <a href="#photos" data-toggle="tab">Galeria</a>
               </li>
               <li <?php echo $active == 'texts' ? 'class="active"' : ''; ?>>
                  <a href="#texts" data-toggle="tab">Textos</a>
               </li>
            </ul>

            <div class="tab-content">
               <div id="photos" class="tab-pane <?php echo $active == 'photos' || $active == false ? 'active' : ''; ?>">

                  <form action="" method="post" id="form_apagar" name="form_apagar">
                     
                     <!-- box -->
                     <div class="box">
                        <div class="box-body">

                           <div style="text-align:left;">
                                 
                                 <button type="button" class="btn btn-primary" onclick="openModalCreate();">Novo</button>
                                 <br/>
                                 <br/>
                                 <form class="form-group">
                                    <div class="form-check">
                                       <input class="form-check-input" type="checkbox" name="enable" id="enable" <?php echo e($enable ? 'checked' : ''); ?> onclick="enablePhotos()" id="flexCheckDefault">
                                       <label class="form-check-label" for="flexCheckDefault">
                                          Habilitar equipe
                                       </label>
                                       </div>
                                    </form>
                                 
                           </div>
                              
                           <table class="table table-bordered table-striped">
                                 
                                 <thead>
                                    <tr>
                              
                                       
                                       <th>Titulo</th>
                                       <th>Titulo</th>
                                       <th>Opt.</th>
                                    </tr>
                                 </thead>
                                 
                                 <tbody id="sortable" class="ui-sortable">
                                 
                                    <?php $__currentLoopData = $photos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                       <tr id="item_22">
                                             
                                             <td><?php echo e($photo->name); ?></td>
                                             <td><img width="80px" src="<?php echo e(asset($photo->image)); ?>"/></td>
                                                <td>
                                                <input type="button" class="btn btn-primary" value="Editar" onclick="openModalEdit(<?php echo e($photo->id); ?>, '<?php echo e($photo->name); ?>', '<?php echo e(asset($photo->image)); ?>')"/>
                                                <input type="button" class="btn btn-danger" value="Apagar" onclick="if (confirm('Excluir imagem selecionada?')) { $('#delete_<?php echo e($photo->id); ?>').submit(); }" />
                                                <form action="<?php echo e(route('admin.photos.destroy', $photo->id)); ?>" method="post" id="delete_<?php echo e($photo->id); ?>" hidden>
                                                   <?php echo csrf_field(); ?>
                                                   <?php echo method_field('DELETE'); ?>
                                                </form>

                                             </td>
                                       </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                       
                                                                     </tbody>

                           </table>

                           <div class="col-12">
                              <div class="col-12 text-right">
                                 <?php echo $photos->links("pagination::bootstrap-4"); ?>


                              </div>
                        </div>

                        </div>

                     </div>
                     <!-- /.box -->

                  </form>

               </div>
               <div id="texts" class="tab-pane <?php echo $active == 'texts' ? 'active' : ''; ?>">
                  <form action="<?php echo e(route('admin.photos.texts.update')); ?>" class="form-horizontal" method="post">
                      <?php echo csrf_field(); ?>
                      <?php echo method_field('PUT'); ?>
                  <fieldset>
                      <div class="form-group">
                         <label class="col-md-12">Titulo</label>
                         <div class="col-md-7">
                            <input name="title" value="<?php echo e($photostexts->title); ?>" type="text" class="form-control">
                         </div>
                      </div>
                      <div class="form-group">
                         <label class="col-md-12">Mmensagem</label>
                         <div class="col-md-7">
                            <textarea class="form-control" name="message"><?php echo e($photostexts->message); ?></textarea>
                         </div>
                      </div>
                   </fieldset>
                   <div>
                      <button type="submit" class="btn btn-primary">Salvar</button>
                   </div>
                  </form>
              </div>
               </div>
        </div>

    </div>
    <!-- /.row -->
</section>
<!-- /.content -->

</div>
<?php echo $__env->make('admin.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>



<script>
    function enablePhotos   (){
        $('#enable').prop( "disabled", true );
        $.ajax({
            headers: {
                    'X-CSRF-Token': "<?php echo e(csrf_token()); ?>",
            },
            type: 'PUT',
            url: "<?php echo e(route('admin.photos.update')); ?>",
            data: { 
                enable: $('#enable').is(':checked')
            },
            enctype: 'multipart/form-data',
            success: function(data){
                $('#enable').prop( "disabled", false );
            },
            error: function(data){
                $('#enable').prop( "disabled", false );
                console.log('Erro no Ajax !');
            }
        });
    }
    function openModalCreate(){
        $('#name').val('');
        $("#create").modal();
    }
    function openModalEdit(id, name, image){
        $('#id_photo').val(id);
        $('#name').val(name);
        $("#image").attr("src",image);

        $("#update").modal();
    }
</script>

<div id="update" class="modal fade" role="dialog">
    <div class="modal-dialog modal-md">
       <!-- Modal content-->
       <div class="modal-content" id="conteudo_modal">
          <div class="modal-header">
             <button type="button" class="close" data-dismiss="modal">×</button>
             <h5 class="modal-title modal_titulo">Editar anúncio</h5>
          </div>
          <div class="modal-body" id="modal_conteudo_m">
             <style type="text/css">
                .bootstrap-timepicker-widget table{
                background-color: #fff !important;
                }
             </style>
             <form action="<?php echo e(route('admin.photos.update')); ?>" class="form-horizontal" method="post" enctype="multipart/form-data">
                 <?php echo csrf_field(); ?>
                 <?php echo method_field('PUT'); ?>
                 <input type="id_schedule" name="id_photo" id="id_photo" hidden />
                <fieldset>
                   <div class="form-group">
                      <label class="col-md-12">Nome do colaborador</label>
                      <div class="col-md-12">
                         <input name="name" id="name" type="text" class="form-control">
                      </div>
                   </div>

                   <div class="form-group">
                      <label class="col-md-12">Imagem</label>
                      <div class="col-md-12">
                         <center><img id="image" src="" width="300px"/></center>
    
                         <fieldset> 
                            <label>Imagem</label> 
                            <div class="fileupload fileupload-new" data-provides="fileupload">
                                <div class="input-append">
                                  <div class="uneditable-input">
                                    <i class="fa fa-file fileupload-exists"></i>
                                    <span class="fileupload-preview"></span>
                                  </div>
                                  <span class="btn btn-default btn-file">
                                  <span class="fileupload-exists">Alterar</span>
                                  <span class="fileupload-new">Procurar arquivo</span>
                                    <input type="file" name="file">
                                  </span>
                                  <a href="#" class="btn btn-default fileupload-exists" data-dismiss="fileupload">Remover</a>
                                </div>
                            </div>
                          </fieldset>
                          <br>
                          <span style="color: #ff0000;"><strong>Tamanho ideal: Largura 1005 x Altura 670</strong></span>
    
    
                      </div>
                   </div>
                   <div style="text-align: left; width: 100%;">
                      <button type="submit" class="btn btn-primary">Salvar</button>
                   </div>
                </fieldset>
             </form>
             <script type="text/javascript">
                $(document).ready(function() {
                
                  $('.timepicker').timepicker({
                    showInputs: false,
                    showMeridian: false
                  });
                
                });
             </script>
          </div>
          <div class="modal-footer">
             <button type="button" class="btn btn-default" data-dismiss="modal">Fechar</button>
          </div>
       </div>
    </div>
    </div>
<div id="create" class="modal fade" role="dialog">
    <div class="modal-dialog modal-md">
       <!-- Modal content-->
       <div class="modal-content" id="conteudo_modal">
          <div class="modal-header">
             <button type="button" class="close" data-dismiss="modal">×</button>
             <h5 class="modal-title modal_titulo">Adicionar foto na galeria</h5>
          </div>
          <div class="modal-body" id="modal_conteudo_m">
             <style type="text/css">
                .bootstrap-timepicker-widget table{
                background-color: #fff !important;
                }
             </style>
             <form action="<?php echo e(route('admin.photos.store')); ?>" class="form-horizontal" method="post" enctype="multipart/form-data">
                 <?php echo csrf_field(); ?>
                 <?php echo method_field('POST'); ?>
                <fieldset>
                   <div class="form-group">
                      <label class="col-md-12">Nome de a foto</label>
                      <div class="col-md-12">
                         <input name="name" id="name" type="text" class="form-control">
                      </div>
                   </div>
                   <div class="form-group">
                      <div class="col-md-12">
                         <fieldset> 
                            <label>Imagem</label> 
                            <div class="fileupload fileupload-new" data-provides="fileupload">
                                <div class="input-append">
                                  <div class="uneditable-input">
                                    <i class="fa fa-file fileupload-exists"></i>
                                    <span class="fileupload-preview"></span>
                                  </div>
                                  <span class="btn btn-default btn-file">
                                  <span class="fileupload-exists">Alterar</span>
                                  <span class="fileupload-new">Procurar arquivo</span>
                                    <input type="file" name="file">
                                  </span>
                                  <a href="#" class="btn btn-default fileupload-exists" data-dismiss="fileupload">Remover</a>
                                </div>
                            </div>
                          </fieldset>
                          <br>   
                          <span style="color: #ff0000;"><strong>Tamanho ideal: Largura 1005 x Altura 670</strong></span>
                      </div>
                   </div>
                   <div style="text-align: left; width: 100%;">
                      <button type="submit" class="btn btn-primary">Salvar</button>
                   </div>
                </fieldset>
             </form>
             <script type="text/javascript">
                $(document).ready(function() {
                
                  $('.timepicker').timepicker({
                    showInputs: false,
                    showMeridian: false
                  });
                
                });
             </script>
          </div>
          <div class="modal-footer">
             <button type="button" class="btn btn-default" data-dismiss="modal">Fechar</button>
          </div>
       </div>
    </div>
    </div><?php /**PATH C:\GIT\sitemoderno\Modules/Photos\Resources/views/admin/index.blade.php ENDPATH**/ ?>