<?php

use Modules\Layout\Entities\Layouts;
use Illuminate\Support\Facades\Artisan;
use Modules\Settings\Entities\Settings;


if ( ! function_exists('layouts'))
{
    function layouts($id)
    {
        $layout = Layouts::where('id', $id)->first();

        return $layout->image;
    }
}

if ( ! function_exists('update'))
{
    function update($option)
    {

        $settings = Settings::first();

        if($option == 'check'){
            $update = json_decode(file_get_contents('http://rep.zievo.com.br/sites/moderno/updates/index.php'));
            
            if($update->version == $settings->version){
                return array(
                    'success' => false,
                    'message' => 'O sistema ja está na última versão'
                );
            }else{
                return array(
                    'success' => true,
                    'message' => 'O sistema precisa ser atualizado'
                );
            }

        }else if($option == 'update'){
            $update = json_decode(file_get_contents('http://rep.zievo.com.br/sites/moderno/updates/index.php'));

            if($update->version == $settings->version){
                return array(
                    'success' => true,
                    'updated' => false,
                    'message' => 'O sistema ja está na última versão'
                );
            }else{
                $url = 'http://rep.zievo.com.br/sites/moderno/updates/' . $update->update;

                if(!is_dir(public_path().'/storage/updates/')){
                    File::makeDirectory(public_path().'/storage/updates/');
                }
                
                file_put_contents(public_path().'/storage/updates/' . $update->update,
                    file_get_contents($url)
                );
            
                $zip = new ZipArchive;
                if ($zip->open(public_path().'/storage/updates/' . $update->update) === TRUE) {
                    $zip->extractTo(base_path());
                    $zip->close();
                    
                    unlink(public_path().'/storage/updates/' . $update->update);
                    
                    $settings->version = $update->version;
                    $settings->save();

                    Artisan::call('config:cache');
                    Artisan::call('config:clear');
                    Artisan::call('cache:clear');
                    Artisan::call('route:clear');
                    Artisan::call('view:clear');
                    Artisan::call('migrate');
                    
                    return array(
                        'success' => true,
                        'updated' => true,
                        'message' => 'O sistema foi atualizado para a última versão'
                    );
                } else {
                    return array(
                        'success' => false,
                        'updated' => false,
                        'message' => 'Falha ao atualizar o sistema'
                    );
                }
            }
        }

    }
}

