<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

/*
Route::prefix('users')->group(function() {
    Route::get('/', 'UsersController@index');
});
*/

Route::group(['middleware' => 'auth'], function () {
    Route::get('/admin/users', '\Modules\Users\Http\Controllers\UsersAdminController@index')->name('admin.users.index');
    Route::post('/admin/users/store', '\Modules\Users\Http\Controllers\UsersAdminController@store')->name('admin.users.store');
    Route::put('/admin/users/update', '\Modules\Users\Http\Controllers\UsersAdminController@update')->name('admin.users.update');
    Route::delete('/admin/users/delete/{id}', '\Modules\Users\Http\Controllers\UsersAdminController@destroy')->name('admin.users.destroy');
});

Route::get('/admin/logout', '\Modules\Users\Http\Controllers\UsersController@logout')->name('logout');
Route::get('/admin/login', '\Modules\Users\Http\Controllers\UsersController@login')->name('login');
Route::post('/admin/auth', '\Modules\Users\Http\Controllers\UsersController@auth')->name('auth');
