@include('admin.header', [
   'elementActive' => 'team'
])

<div class="content-wrapper">

    <section class="content-header">
      <h1>
      Equipe	      <small></small>
      </h1> 
    </section>

    <!-- Main content -->
    <section class="content">
    <div class="row">
        
        <div class="col-xs-12">   
           
         <div class="nav-tabs-custom">
            <ul class="nav nav-tabs ">
               <li {!! $active == 'team' || $active == false ? 'class="active"' : '' !!}  >
                  <a href="#team" data-toggle="tab">Equipe</a>
               </li>
               <li {!! $active == 'texts' ? 'class="active"' : '' !!}>
                  <a href="#texts" data-toggle="tab">Textos</a>
               </li>
            </ul>
            
            <div class="tab-content">

               <div id="team" class="tab-pane {!! $active == 'team' || $active == false ? 'active' : '' !!}">
                  <form method="post" id="form_apagar" name="form_apagar">

                     <!-- box -->
                     <div class="box">
                        <div class="box-body">

                           <div style="text-align:left;">

                                 <button type="button" class="btn btn-primary" onclick="openModalCreate()">Novo</button>

                           </div>		
                           <br/>         
                           <form class="form-group">
                                 <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="enable" id="enable" {{ $enable ? 'checked' : '' }} onclick="enableTeams()" id="flexCheckDefault">
                                    <label class="form-check-label" for="flexCheckDefault">
                                       Habilitar equipe
                                    </label>
                                 </div>
                                 </form>

                           

                           <table class="table table-bordered table-striped">

                                 <thead>
                                    <tr>
                                       <th>Ord.</th>
                                       <th>Imagem</th>
                                       <th>Titulo</th>
                                       <th>Opt.</th>
                                    </tr>
                                 </thead>
                                 
                                 <tbody id="sortable" class="ui-sortable">
                                 
                                    @foreach ($teams as $team)
                                    <tr id="{{ $team->id }}">
                                       <td style="width:30px; cursor:move; text-align:center;">
                                             <i class="fa fa-arrows-v"></i>
                                       </td>
                                       <td onclick="{{ route('admin.team.edit', $team->id) }}" style="cursor:pointer;">{{ $team->name }} - {{ $team->sector }}</td>
                                       <td onclick="{{ route('admin.team.edit', $team->id) }}" style="cursor:pointer;"><img src="{{ asset($team->image) }}" width="80px"/></td>
                                       <td>

                                             <input type="button" class="btn btn-primary" value="Editar" onclick="openModalEdit({{ $team->id }}, '{{ $team->name }}', '{{ $team->sector }}', '{{ $team->social_network }}', '{{ asset($team->image) }}')"/>
                                             <input type="button" class="btn btn-danger" value="Apagar" onclick="if (confirm('Excluir o colaborador selecionado?')) { $('#delete_{{ $team->id }}').submit(); }" />
                                             <form action="{{ route('admin.team.destroy', $team->id) }}" method="post" id="delete_{{ $team->id }}" hidden>
                                                @csrf
                                                @method('DELETE')
                                             </form>

                                       </td>
                                    </tr>
                                    @endforeach
                                       
                                       
                                 </tbody>

                           </table>

                        </div>

                     </div>
                     <!-- /.box -->

               </form>
               </div>
               <div id="texts" class="tab-pane {!! $active == 'texts' ? 'active' : '' !!}">

                  <form action="{{ route('admin.team.texts.update') }}" class="form-horizontal" method="post">
                     @csrf
                     @method('PUT')
                     <fieldset>
                           <div class="form-group">
                              <label class="col-md-12">Titulo</label>
                              <div class="col-md-7">
                                 <input name="title" value="{{ $teamstexts->title }}" type="text" class="form-control">
                              </div>
                           </div>
                           <div class="form-group">
                              <label class="col-md-12">Mmensagem</label>
                              <div class="col-md-7">
                                 <textarea class="form-control" name="message">{{ $teamstexts->message  }}</textarea>
                              </div>
                           </div>
                        </fieldset>
                        <div>
                           <button type="submit" class="btn btn-primary">Salvar</button>
                        </div>
                 </form>
                 
               </div>
        </div>

    </div>
    </div>
    <!-- /.row -->
</section>
<!-- /.content -->

</div>
@include('admin.footer')

<script>
	$(function() {
		$( "#sortable" ).sortable({
			update: function(event, ui){
                
				var formData = $('#sortable').sortable('toArray');

                $.ajax({
                headers: {
                        'X-CSRF-Token': "{{ csrf_token() }}",
                },
                type: 'PUT',
                url: "{{ route('admin.team.update') }}",
                data: { 
                    order: $('#sortable').sortable('toArray')
                },
                enctype: 'multipart/form-data',
                success: function(data){
                   
                },
                error: function(data){

                    console.log('Erro no Ajax !');
                }
            });

			}
		});
	});
</script>




<script>
    function enableTeams(){
        $('#enable').prop( "disabled", true );
        $.ajax({
            headers: {
                    'X-CSRF-Token': "{{ csrf_token() }}",
            },
            type: 'PUT',
            url: "{{ route('admin.team.update') }}",
            data: { 
                enable: $('#enable').is(':checked')
            },
            enctype: 'multipart/form-data',
            success: function(data){
                $('#enable').prop( "disabled", false );
            },
            error: function(data){
                $('#enable').prop( "disabled", false );
                console.log('Erro no Ajax !');
            }
        });
    }
    function openModalCreate(){
        $('#name').val('');
        $('#sector').val('');
        $('#social_network').val('');

        $("#create").modal();
    }
    function openModalEdit(id, name, sector, social_network, image){
        $('#id_teams').val(id);
        $('#name').val(name);
        $('#sector').val(sector);
        $('#social_network').val(social_network);
        $("#image").attr("src",image);

        $("#update").modal();
    }
</script>

<div id="update" class="modal fade" role="dialog">
    <div class="modal-dialog modal-md">
       <!-- Modal content-->
       <div class="modal-content" id="conteudo_modal">
          <div class="modal-header">
             <button type="button" class="close" data-dismiss="modal">×</button>
             <h5 class="modal-title modal_titulo">Editar anúncio</h5>
          </div>
          <div class="modal-body" id="modal_conteudo_m">
             <style type="text/css">
                .bootstrap-timepicker-widget table{
                background-color: #fff !important;
                }
             </style>
             <form action="{{ route('admin.team.update') }}" class="form-horizontal" method="post" enctype="multipart/form-data">
                 @csrf
                 @method('PUT')
                 <input type="id_schedule" name="id_teams" id="id_teams" hidden />
                <fieldset>
                   <div class="form-group">
                      <label class="col-md-12">Nome do colaborador</label>
                      <div class="col-md-12">
                         <input name="name" id="name" type="text" class="form-control">
                      </div>
                   </div>
                   <div class="form-group">
                      <label class="col-md-12">Setor</label>
                      <div class="col-md-12">
                         <input name="sector" id="sector" type="text" class="form-control" placeholder="http://google.com.br">
                      </div>
                   </div>
                   <div class="form-group">
                    <label class="col-md-12">Rede Social</label>
                    <div class="col-md-12">
                       <input name="social_network" id="social_network" type="text" class="form-control" placeholder="http://google.com.br">
                    </div>
                 </div>
                   <div class="form-group">
                      <label class="col-md-12">Imagem</label>
                      <div class="col-md-12">
                         <center><img id="image" src="" width="300px"/></center>
    
                         <fieldset> 
                            <label>Imagem</label> 
                            <div class="fileupload fileupload-new" data-provides="fileupload">
                                <div class="input-append">
                                  <div class="uneditable-input">
                                    <i class="fa fa-file fileupload-exists"></i>
                                    <span class="fileupload-preview"></span>
                                  </div>
                                  <span class="btn btn-default btn-file">
                                  <span class="fileupload-exists">Alterar</span>
                                  <span class="fileupload-new">Procurar arquivo</span>
                                    <input type="file" name="file">
                                  </span>
                                  <a href="#" class="btn btn-default fileupload-exists" data-dismiss="fileupload">Remover</a>
                                </div>
                            </div>
                          </fieldset>
                          <br>
                          <span style="color: #ff0000;"><strong>Tamanho ideal: Largura 474 x Altura 248</strong></span>
    
    
                      </div>
                   </div>
                   <div style="text-align: left; width: 100%;">
                      <button type="submit" class="btn btn-primary">Salvar</button>
                   </div>
                </fieldset>
             </form>
             <script type="text/javascript">
                $(document).ready(function() {
                
                  $('.timepicker').timepicker({
                    showInputs: false,
                    showMeridian: false
                  });
                
                });
             </script>
          </div>
          <div class="modal-footer">
             <button type="button" class="btn btn-default" data-dismiss="modal">Fechar</button>
          </div>
       </div>
    </div>
    </div>
<div id="create" class="modal fade" role="dialog">
    <div class="modal-dialog modal-md">
       <!-- Modal content-->
       <div class="modal-content" id="conteudo_modal">
          <div class="modal-header">
             <button type="button" class="close" data-dismiss="modal">×</button>
             <h5 class="modal-title modal_titulo">Adicionar colaborador</h5>
          </div>
          <div class="modal-body" id="modal_conteudo_m">
             <style type="text/css">
                .bootstrap-timepicker-widget table{
                background-color: #fff !important;
                }
             </style>
             <form action="{{ route('admin.team.store') }}" class="form-horizontal" method="post" enctype="multipart/form-data">
                 @csrf
                 @method('POST')
                <fieldset>
                   <div class="form-group">
                      <label class="col-md-12">Nome do colaborador</label>
                      <div class="col-md-12">
                         <input name="name" id="name" type="text" class="form-control">
                      </div>
                   </div>
                   <div class="form-group">
                      <label class="col-md-12">Setor</label>
                      <div class="col-md-12">
                         <input name="sector" id="sector" type="text" class="form-control" placeholder="Locutor">
                      </div>
                   </div>
                   <div class="form-group">
                    <label class="col-md-12">Rede Social</label>
                    <div class="col-md-12">
                       <input name="social_network" id="social_network" type="text" class="form-control">
                    </div>
                 </div>
                   <div class="form-group">
                      <div class="col-md-12">
                         <fieldset> 
                            <label>Imagem</label> 
                            <div class="fileupload fileupload-new" data-provides="fileupload">
                                <div class="input-append">
                                  <div class="uneditable-input">
                                    <i class="fa fa-file fileupload-exists"></i>
                                    <span class="fileupload-preview"></span>
                                  </div>
                                  <span class="btn btn-default btn-file">
                                  <span class="fileupload-exists">Alterar</span>
                                  <span class="fileupload-new">Procurar arquivo</span>
                                    <input type="file" name="file">
                                  </span>
                                  <a href="#" class="btn btn-default fileupload-exists" data-dismiss="fileupload">Remover</a>
                                </div>
                            </div>
                          </fieldset>
                          <br>   
    
                      </div>
                   </div>
                   <div style="text-align: left; width: 100%;">
                      <button type="submit" class="btn btn-primary">Salvar</button>
                   </div>
                </fieldset>
             </form>
             <script type="text/javascript">
                $(document).ready(function() {
                
                  $('.timepicker').timepicker({
                    showInputs: false,
                    showMeridian: false
                  });
                
                });
             </script>
          </div>
          <div class="modal-footer">
             <button type="button" class="btn btn-default" data-dismiss="modal">Fechar</button>
          </div>
       </div>
    </div>
    </div>


