<?php

namespace Modules\Team\Http\Controllers;

use Image;
use Illuminate\Http\Request;
use Modules\Team\Entities\Teams;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Contracts\Support\Renderable;
use Modules\Schedule\Entities\TeamTexts;

class TeamAdminController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        if(isset($_GET['active'])){
            $active = $_GET['active'];
        }else{
            $active = false;
        }

        $enable = Teams::first();
        $teams = Teams::orderBy('order')->get();
        $teamstexts = TeamTexts::first();

        return view('team::admin.index',
            [
                'teams' => $teams,
                'enable' => $enable->enable,
                'active' => $active,
                'teamstexts' => $teamstexts
            ]
        );
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        return view('team::create');
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        $data = $request->all();

        $name = $data['name'];
        $sector = $data['sector'];
        $social_network = $data['social_network'];
        $image = isset($data['file']) ? $data['file'] : false;

        $order = Teams::count();

        $team = new Teams();

        if($image){

            $imageName = time().'_'.rand(10,1000).rand(10,1000).rand(10,1000).'.'.$image->extension();  
        
            $image->move(public_path('storage/img/teams'), $imageName);
    
            $image = Image::make(public_path('storage/img/teams/').$imageName);

            $fileName = pathinfo(public_path($team->image))['filename'];

            $team->image = 'storage/img/teams/'.$imageName;
        }

        $team->name = $name;
        $team->sector = $sector;
        $team->social_network = $social_network;
        $team->order = $order + 1;
        $team->save();

        return redirect()->route('admin.team.index');

    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('team::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        return view('team::edit');
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request)
    {
        $data = $request->all();


        if(isset($data['order'])){

            $count = 1;
            foreach($data['order'] as $order){
                $team = Teams::where('id', $order)->first();

                $team->order = $count;
                $team->save();
                $count++;
            }

            return array(
                'success' => true,
                'message' => 'Alterado com sucesso!'
            );

        }else if(isset($data['enable'])){

            $enable = $data['enable'] == 'true' ? true : false;

            DB::table('teams')->update(['enable' => $enable]);

            return array(
                'success' => true,
                'message' => 'Alterado com sucesso'
            );

        }else{
    
            $id_teams = $data['id_teams'];
            $name = $data['name'];
            $sector = $data['sector'];
            $social_network = $data['social_network'];
            $image = isset($data['file']) ? $data['file'] : false;

            $order = Teams::count();

            $team = Teams::where('id', $id_teams)->first();

            if($image){

                $imageName = time().'_'.rand(10,1000).rand(10,1000).rand(10,1000).'.'.$image->extension();  
            
                $image->move(public_path('storage/img/teams'), $imageName);
        
                $image = Image::make(public_path('storage/img/teams/').$imageName);

                $fileName = pathinfo(public_path($team->image))['filename'];

                if($fileName != 'default'){
                    @unlink(public_path($team->image));
                }

                $team->image = 'storage/img/teams/'.$imageName;
            }

            $team->name = $name;
            $team->sector = $sector;
            $team->social_network = $social_network;
            $team->order = $order + 1;
            $team->save();

            return redirect()->route('admin.team.index');
        }
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        $team = Teams::where('id', $id)->first();

        if($team){

            $fileName = pathinfo(public_path($team->image))['filename'];

            if($fileName != 'default'){
                @unlink(public_path($team->image));
            }

            $team->delete();
        }

        return redirect()->route('admin.team.index');
    }
}
