<?php

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTeamsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('teams', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('sector')->nullable();
            $table->string('social_network')->nullable();
            $table->integer('order');
            $table->string('image')->default('storage/img/teams/default.jpg');
            $table->boolean('enable')->default(true);
            $table->timestamps();
        });

        DB::table('teams')->insert(['name' => 'Roberto Jr', 'sector' => 'Edição e Marketing', 'social_network' => '', 'order' => 1, 'image' => 'storage/img/teams/3165036511654324.jpg', 'created_at' => now(), 'updated_at' => now()]);
        DB::table('teams')->insert(['name' => 'Wesley Carmo', 'sector' => 'Desenvolvedor Web', 'social_network' => '', 'order' => 1, 'image' => 'storage/img/teams/6516514324324651.jpg', 'created_at' => now(), 'updated_at' => now()]);
        DB::table('teams')->insert(['name' => 'Amanda Cordeiro', 'sector' => 'Marketing', 'social_network' => '', 'order' => 1, 'image' => 'storage/img/teams/65165132146543.jpg', 'created_at' => now(), 'updated_at' => now()]);
        DB::table('teams')->insert(['name' => 'José Coelho', 'sector' => 'Diretor Geral', 'social_network' => '', 'order' => 1, 'image' => 'storage/img/teams/616514324313213.jpg', 'created_at' => now(), 'updated_at' => now()]);
    
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('teams');
    }
}
