<?php

namespace Modules\Stream\Http\Controllers;

use GuzzleHttp\RetryMiddleware;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Stream\Entities\Streams;
use Illuminate\Contracts\Support\Renderable;

class StreamAdminController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        $stream = Streams::first();
        
        return view('stream::admin.index',
            [
                'stream' => $stream
            ]
        );
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        return view('stream::create');
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('stream::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        return view('stream::edit');
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $id)
    {
        $data = $request->all();
        $player_popup = $data['player_popup'];
        $enable_player_popup = isset($data['enable_player_popup']) ? true : false;
        $player = $data['player'];
        $enable_player = isset($data['enable_player']) ? true : false;
        $web_tv = $data['web_tv'];
        $enable_webtv = isset($data['enable_webtv']) ? true : false;
        $chat = $data['chat'];
        $enable_chat = isset($data['enable_chat']) ? true : false;
        $current_song = $data['current_song'];
        $enable_current_song = isset($data['enable_current_song']) ? true : false;

        $stream = Streams::where('id', $id)->first();

        $stream->player_popup = $player_popup;
        $stream->enable_player_popup = $enable_player_popup;
        $stream->player = $player;
        $stream->enable_player = $enable_player;
        $stream->web_tv = $web_tv;
        $stream->enable_webtv = $enable_webtv;
        $stream->chat = $chat;
        $stream->enable_chat = $enable_chat;
        $stream->current_song = $current_song;
        $stream->enable_current_song = $enable_current_song;

        $stream->save();

        return redirect()->route('admin.stream.index');
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        //
    }
}
