@include('admin.header', [
   'elementActive' => 'settings'
])
<div class="content-wrapper" style="min-height: 869px;">
    <section class="content-header">
       <h1>
          Configurações
          <small>Altere as configurações do seu WebSite</small>
       </h1>
    </section>

    

    <!-- Main content -->
    <section class="content">
       <div class="row">
          <div class="col-xs-12">
             <div class="nav-tabs-custom">
                <ul class="nav nav-tabs ">
                   <li {!! $active == 'info' || $active == false ? 'class="active"' : '' !!}  >
                      <a href="#emails" data-toggle="tab">E-mails do Contato</a>
                   </li>
                   <li {!! $active == 'meta' ? 'class="active"' : '' !!}>
                      <a href="#meta" data-toggle="tab">Meta</a>
                   </li>
                   <li {!! $active == 'smtp' ? 'class="active"' : '' !!}>
                      <a href="#smtp" data-toggle="tab">Configuração de envio (SMTP)</a>
                   </li>
                </ul>
                <div class="tab-content">
                   <div id="emails" class="tab-pane {!! $active == 'info' || $active == false ? 'active' : '' !!}">
                      <form action="{{ route('admin.settings.update', 'info') }}" class="form-horizontal" method="post">
                        @csrf
                        @method('PUT')
                        <fieldset>
                           <div class="form-group">
                              <label class="col-md-12">Informações de contato</label>
                              <div class="col-md-7">
                                 <input name="email" value="{{ $settings->email }}" type="text" class="form-control">
                              </div>
                           </div>
                           <div class="form-group">
                              <label class="col-md-12">Facebook</label>
                              <div class="col-md-7">
                                 <input name="facebook" value="{{ $settings->facebook }}" type="text" class="form-control">
                              </div>
                           </div>
                           <div class="form-group">
                              <label class="col-md-12">Instagram</label>
                              <div class="col-md-7">
                                 <input name="instagram" value="{{ $settings->instagram }}" type="text" class="form-control">
                              </div>
                           </div>
                           <div class="form-group">
                              <label class="col-md-12">Twitter</label>
                              <div class="col-md-7">
                                 <input name="twitter" value="{{ $settings->twitter }}" type="text" class="form-control">
                              </div>
                           </div>
                           <div class="form-group">
                              <label class="col-md-12">WhatsApp</label>
                              <div class="col-md-7">
                                 <input name="whatsapp" value="{{ $settings->whatsapp }}" type="text" class="form-control">
                              </div>
                           </div>
                           <div class="form-group">
                              <label class="col-md-12">Telefone 1</label>
                              <div class="col-md-7">
                                 <input name="phone1" value="{{ $settings->phone1 }}" type="text" class="form-control">
                              </div>
                           </div>
                           <div class="form-group">
                              <label class="col-md-12">Telefone 2</label>
                              <div class="col-md-7">
                                 <input name="phone2" value="{{ $settings->phone2 }}" type="text" class="form-control">
                              </div>
                           </div>
                           <div class="form-group">
                              <label class="col-md-12">Endereço</label>
                              <div class="col-md-7">
                                 <input name="address" value="{{ $settings->address }}" type="text" class="form-control">
                              </div>
                           </div>
                        </fieldset>
                        <div>
                           <button type="submit" class="btn btn-primary">Salvar</button>
                        </div>
                      </form>
                   </div>
                   <div id="meta" class="tab-pane {!! $active == 'meta' ? 'active' : '' !!}">
                     <form action="{{ route('admin.settings.update', 'meta') }}" class="form-horizontal" method="post">
                        @csrf
                        @method('PUT')
                         <fieldset>
                            <div class="form-group">
                               <label class="col-md-12">Titulo Página</label>
                               <div class="col-md-7">
                                  <input name="title" value="{{ $settings->title }}" type="text" class="form-control" >
 
                                 @if (\Session::has('title'))
                                    <span class="text-danger" style="display: block;" role="alert">
                                       <strong>{!! \Session::get('title') !!}</strong>
                                    </span>
                                 @endif
                              </div>
                               
                            </div>
                            <div class="form-group">
                               <label class="col-md-12">Descrição</label>
                               <div class="col-md-7">
                                  <input name="description" value="{{ $settings->description }}" type="text" class="form-control" >
                                  @if (\Session::has('description'))
                                    <span class="text-danger" style="display: block;" role="alert">
                                       <strong>{!! \Session::get('description') !!}</strong>
                                    </span>
                                 @endif
                               </div>
                              
                            </div>
                            <div class="form-group">
                               <label class="col-md-12">Meta Descrição</label>
                               <div class="col-md-7">
                                  <input name="meta" value="{{ $settings->meta }}" type="text" class="form-control" >
                                  @if (\Session::has('meta'))
                                    <span class="text-danger" style="display: block;" role="alert">
                                       <strong>{!! \Session::get('meta') !!}</strong>
                                    </span>
                                 @endif
                               </div>
                               
                            </div>
                         </fieldset>
                         <div>
                            <button type="submit" class="btn btn-primary">Salvar</button>
                         </div>
                      </form>
                   </div>
                   <div id="smtp" class="tab-pane {!! $active == 'smtp' ? 'active' : '' !!}">

                     <form class="form-group">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="enable" id="enable" {{ $enable ? 'checked' : '' }} onclick="enableSTMP()" id="flexCheckDefault">
                            <label class="form-check-label" for="flexCheckDefault">
                              Habilitar envio de mensagens pelo site
                            </label>
                          </div>
                    </form>

                     <form action="{{ route('admin.settings.update', 'smtp') }}" class="form-horizontal" method="post">
                        @csrf
                        @method('PUT')
                         <fieldset>
                            <div class="form-group">
                               <label class="col-md-12">Nome de Exibição</label>
                               <div class="col-md-7">
                                  <input name="smtp_name" value="{{ $settings->smtp_name }}" type="text" class="form-control" >
                               </div>
                            </div>
                            <div class="form-group">
                               <label class="col-md-12">E-mail de Origem</label>
                               <div class="col-md-7">
                                  <input name="smtp_source_email" value="{{ $settings->smtp_source_email }}" type="text" class="form-control" >
                               </div>
                            </div>
                            <div class="form-group">
                               <label class="col-md-12">E-mail de Retorno</label>
                               <div class="col-md-7">
                                  <input name="smtp_source_return" value="{{ $settings->smtp_source_return }}" type="text" class="form-control" >
                               </div>
                            </div>
                            <div class="form-group">
                               <label class="col-md-12">Porta</label>
                               <div class="col-md-7">
                                  <input name="smtp_port"  value="{{ $settings->port }}" type="text" class="form-control" value="587">
                               </div>
                            </div>
                            <div class="form-group">
                               <label class="col-md-12">E-mail - Host</label>
                               <div class="col-md-7">
                                  <input name="smtp_host" value="{{ $settings->smtp_host }}" type="text" class="form-control" >
                               </div>
                            </div>
                            <div class="form-group">
                               <label class="col-md-12">E-mail - Usuário</label>
                               <div class="col-md-7">
                                  <input name="smtp_user" value="{{ $settings->smtp_user }}" type="text" class="form-control" >
                               </div>
                            </div>
                            <div class="form-group">
                               <label class="col-md-12">E-mail - Senha</label>
                               <div class="col-md-7">
                                  <input name="smtp_password" value="{{ $settings->smtp_password }}" type="text" class="form-control" >
                               </div>
                            </div>
                            <div class="form-group">
                              <label class="col-md-12">Segurança SMTP</label>
                              <div class="col-md-7">
                              <select class="form-control" name="smtp_security" id="smtp_security" >    
                                <option value="ssl">SSL</option>
                                <option value="tsl">TSL</option>
                                <option value="auto">Automático</option>
                                <option value="STARTTLS">STARTTLS</option>
                                <option value="notls">NOTLS</option>
                                <option value="smtp/ssl/novalidate-cert">Não validar</option>
                              </select>
                            </div>
                            </div>
                         </fieldset>
                         <div>
                            <button type="submit" class="btn btn-primary">Salvar</button>
                         </div>
                      </form>
                   </div>
                </div>
             </div>
          </div>
          <!-- /.row -->
       </div>
    </section>
    <!-- /.content -->
 </div>

@include('admin.footer')

<script>
function enableSTMP(){
        $('#enable').prop( "disabled", true );
        $.ajax({
            headers: {
                    'X-CSRF-Token': "{{ csrf_token() }}",
            },
            type: 'PUT',
            url: "{{ route('admin.settings.update', 'enable') }}",
            data: { 
                enable: $('#enable').is(':checked')
            },
            enctype: 'multipart/form-data',
            success: function(data){
                $('#enable').prop( "disabled", false );
            },
            error: function(data){
                $('#enable').prop( "disabled", false );
                console.log('Erro no Ajax !');
            }
        });
    }
</script>