<?php

namespace Modules\Settings\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Settings\Entities\Settings;
use Illuminate\Contracts\Support\Renderable;
use Modules\Settings\Http\Requests\SettingsAdminRequest;

class SettingsAdminController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        if(isset($_GET['active'])){
            $active = $_GET['active'];
        }else{
            $active = false;
        }
        
        $settings = Settings::first();

        return view('settings::admin.index',
            [
                'settings' => $settings,
                'enable' => $settings->smtp_enable,
                'active' => $active
            ]
        );
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        return view('settings::create');
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('settings::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        return view('settings::edit');
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $type)
    {
        $data = $request->all();

        if($type == 'enable'){
                
            $enable = isset($data['enable']) && $data['enable'] == 'true' ? true : false;
    
            DB::table('settings')->update(['smtp_enable' => $enable]);
    
            return array(
               'success' => true,
                'message' => 'Alterado com sucesso'
            );
            
        }else if($type == 'info'){

            $settings = Settings::first();
            
            $settings->email = isset($data['email']) ? $data['email'] : '';    
            $settings->facebook = isset($data['facebook']) ? $data['facebook'] : '';
            $settings->instagram = isset($data['instagram']) ? $data['instagram'] : '';
            $settings->whatsapp = isset($data['whatsapp']) ? $data['whatsapp'] : '';
            $settings->phone1 = isset($data['phone1']) ? $data['phone1'] : '';
            $settings->phone2 = isset($data['phone2']) ? $data['phone2'] : '';
            $settings->address = isset($data['address']) ? $data['address'] : '';

            $settings->save();

            return redirect()->route('admin.settings.index',
                [
                    'active' => 'info'
                ]
            );
            
        }else if($type == 'meta'){

            $settings = Settings::first();

            if(!isset($data['title'])){
                return redirect()->back()->with('title', 'Informe o titulo do site'); 
            }
            if(!isset($data['description'])){
                return redirect()->back()->with('description', 'Defina uma descrição para o site'); 
            }
            if(!isset($data['meta'])){
                return redirect()->back()->with('meta', 'Informe os metadados do site, ex: site, rádio, músicas, novidades'); 
            }
            
            $settings->title = $data['title'];
            $settings->description = $data['description'];
            $settings->meta = $data['meta'];

            $settings->save();

            return redirect()->route('admin.settings.index',
                [
                    'active' => 'meta'
                ]
            );

        }else if($type == 'smtp'){

            $settings = Settings::first();

            $settings->smtp_name = $data['smtp_name'];
            $settings->smtp_source_email = $data['smtp_source_email'];
            $settings->smtp_source_return = $data['smtp_source_return'];
            $settings->smtp_port = $data['smtp_port'];
            $settings->smtp_host = $data['smtp_host'];
            $settings->smtp_user = $data['smtp_user'];
            $settings->smtp_password = $data['smtp_password'];

            $settings->save();

            return redirect()->route('admin.settings.index',
                [
                    'active' => 'smtp'
                ]
            );

        }
        
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        //
    }
}
