@include('admin.header', [
   'elementActive' => 'schedule'
])

<div class="content-wrapper">

    <section class="content-header">
        <h1>
            Programação					<small></small>
        </h1> 
    </section>

    <section class="content">
        <div class="row">
            <div class="col-xs-12">

                <div style="padding-bottom: 20px;">
                    <button type="button" class="btn btn-primary" onclick="openModalCreate();">Novo</button>
                </div>
                <form class="form-group">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" name="enable" id="enable" {{ $schedules->enable ? 'checked' : '' }} onclick="enableSchedule()" id="flexCheckDefault">
                        <label class="form-check-label" for="flexCheckDefault">
                          Habilitar programação
                        </label>
                      </div>
                    </form>
                <div class="nav-tabs-custom">

                    <ul class="nav nav-tabs ">

                        <li {!! $action == 'sunday' || $action == false ? 'class="active"' : '' !!}>
                            <a href="#domingo" data-toggle="tab">Domingo</a>
                        </li>
                        <li {!! $action == 'monday' ? 'class="active"' : '' !!}>
                            <a href="#segunda" data-toggle="tab">Segunda</a>
                        </li>
                        <li {!! $action == 'tuesday' ? 'class="active"' : '' !!}>
                            <a href="#terca" data-toggle="tab">Terça</a>
                        </li>
                        <li {!! $action == 'wednesday' ? 'class="active"' : '' !!}>
                            <a href="#quarta" data-toggle="tab">Quarta</a>
                        </li>
                        <li {!! $action == 'thursday' ? 'class="active"' : '' !!}>
                            <a href="#quinta" data-toggle="tab">Quinta</a>
                        </li>
                        <li {!! $action == 'friday' ? 'class="active"' : '' !!}>
                            <a href="#sexta" data-toggle="tab">Sexta</a>
                        </li>
                        <li {!! $action == 'saturday' ? 'class="active"' : '' !!}>
                            <a href="#sabado" data-toggle="tab">Sábado</a>
                        </li>

                    </ul>

                    
                    
                    <div class="tab-content">
                        
                        
                        
                        <div id="domingo" class="tab-pane {!! $action == 'sunday' || $action == false ? 'active' : '' !!}">
                            <table id="tabela_0" class="table table-bordered table-hover">
                                
                                <thead>
                                    <tr>
                                        <th>Início</th>
                                        <th>Programa</th>
                                        <th></th>
                                    </tr>
                                </thead>

                                <tbody>
                                    
                                    @foreach($schedules->sunday as $sunday)
                                        <tr>												
                                            <td onclick="" style="cursor:pointer;"> {{ $sunday->start_time  }}</td>
                                            <td onclick="">{{ $sunday->name }}</td>
                                            <td>
                                                <input type="button" class="btn btn-primary" value="Editar" onclick="openModalEdit({{ $sunday->id }}, '{{ $sunday->day_the_week }}', '{{ $sunday->start_time }}', '{{ $sunday->name }}', '{{ $sunday->presenter }}', '{{ $sunday->description }}')" />
                                                <input type="button" class="btn btn-danger" value="Apagar" onclick="if (confirm('Excluir a programação selecionada?')) { $('#delete_{{ $sunday->id }}').submit(); }" />
                                                <form action="{{ route('admin.schedule.destroy', $sunday->id) }}" method="post" id="delete_{{ $sunday->id }}" hidden>
                                                    @csrf
                                                    @method('DELETE')
                                                </form>
                                            </td>
                                        </tr>
                                    @endforeach
                                        
                                </tbody>

                            </table>
                        </div>


                        <div id="segunda" class="tab-pane {!! $action == 'monday' ? 'active' : '' !!}">
                            <table id="tabela_1" class="table table-bordered table-hover">

                                <thead>
                                    <tr>
                                        <th>Início</th>
                                        <th>Programa</th>
                                        <th></th>
                                    </tr>
                                </thead>

                                <tbody>
                                    
                                    @foreach($schedules->monday as $monday)
                                        <tr>												
                                            <td onclick="" style="cursor:pointer;"> {{ $monday->start_time  }}</td>
                                            <td onclick="">{{ $monday->name }}</td>
                                            <td>
                                                <input type="button" class="btn btn-primary" value="Editar" value="Editar" onclick="openModalEdit({{ $monday->id }}, '{{ $monday->day_the_week }}', '{{ $monday->start_time }}', '{{ $monday->name }}', '{{ $monday->presenter }}', '{{ $monday->description }}')"/>
                                                <input type="button" class="btn btn-danger" value="Apagar" onclick="if (confirm('Excluir a programação selecionada?')) { $('#delete_{{ $monday->id }}').submit(); }" />
                                                <form action="{{ route('admin.schedule.destroy', $monday->id) }}" method="post" id="delete_{{ $monday->id }}" hidden>
                                                    @csrf
                                                    @method('DELETE')
                                                </form>
                                            </td>
                                        </tr>
                                    @endforeach

                                </tbody>

                            </table>
                        </div>


                        <div id="terca" class="tab-pane {!! $action == 'tuesday' ? 'active' : '' !!}">
                            <table id="tabela_2" class="table table-bordered table-hover">

                                <thead>
                                    <tr>
                                        <th>Início</th>
                                        <th>Programa</th>
                                        <th></th>
                                    </tr>
                                </thead>

                                <tbody>
                                    
                                    @foreach($schedules->tuesday as $tuesday)
                                    <tr>												
                                        <td onclick="" style="cursor:pointer;"> {{ $tuesday->start_time  }}</td>
                                        <td onclick="">{{ $tuesday->name }}</td>
                                        <td>
                                            <input type="button" class="btn btn-primary" value="Editar" value="Editar" onclick="openModalEdit({{ $tuesday->id }}, '{{ $tuesday->day_the_week }}', '{{ $tuesday->start_time }}', '{{ $tuesday->name }}', '{{ $tuesday->presenter }}', '{{ $tuesday->description }}')"/>
                                            <input type="button" class="btn btn-danger" value="Apagar" onclick="if (confirm('Excluir a programação selecionada?')) { $('#delete_{{ $tuesday->id }}').submit(); }" />
                                            <form action="{{ route('admin.schedule.destroy', $tuesday->id) }}" method="post" id="delete_{{ $tuesday->id }}" hidden>
                                                @csrf
                                                @method('DELETE')
                                            </form>
                                        </td>
                                    </tr>
                                    @endforeach
                                    
                                </tbody>

                            </table>
                        </div>


                        <div id="quarta" class="tab-pane {!! $action == 'wednesday' ? 'active' : '' !!}">
                            <table id="tabela_3" class="table table-bordered table-hover">

                                <thead>
                                    <tr>
                                        <th>Início</th>
                                        <th>Programa</th>
                                        <th></th>
                                    </tr>
                                </thead>

                                <tbody>
                                    
                                    @foreach($schedules->wednesday as $wednesday)
                                    <tr>												
                                        <td onclick="" style="cursor:pointer;"> {{ $wednesday->start_time  }}</td>
                                        <td onclick="">{{ $wednesday->name }}</td>
                                        <td>
                                            <input type="button" class="btn btn-primary" value="Editar" value="Editar" onclick="openModalEdit({{ $wednesday->id }}, '{{ $wednesday->day_the_week }}', '{{ $wednesday->start_time }}', '{{ $wednesday->name }}', '{{ $wednesday->presenter }}', '{{ $wednesday->description }}')"/>
                                            <input type="button" class="btn btn-danger" value="Apagar" onclick="if (confirm('Excluir a programação selecionada?')) { $('#delete_{{ $wednesday->id }}').submit(); }" />
                                            <form action="{{ route('admin.schedule.destroy', $wednesday->id) }}" method="post" id="delete_{{ $wednesday->id }}" hidden>
                                                @csrf
                                                @method('DELETE')
                                            </form>
                                        </td>
                                    </tr>
                                    @endforeach
                                    
                                </tbody>

                            </table>
                        </div>


                        <div id="quinta" class="tab-pane {!! $action == 'thursday' ? 'active' : '' !!}">
                            <table id="tabela_4" class="table table-bordered table-hover">

                                <thead>
                                    <tr>
                                        <th>Início</th>
                                        <th>Programa</th>
                                        <th></th>
                                    </tr>
                                </thead>

                                
                                <tbody>
                                    
                                    @foreach($schedules->thursday as $thursday)
                                    <tr>												
                                        <td onclick="" style="cursor:pointer;"> {{ $thursday->start_time  }}</td>
                                        <td onclick="">{{ $thursday->name }}</td>
                                        <td>
                                            <input type="button" class="btn btn-primary" value="Editar" value="Editar" onclick="openModalEdit({{ $thursday->id }}, '{{ $thursday->day_the_week }}', '{{ $thursday->start_time }}', '{{ $thursday->name }}', '{{ $thursday->presenter }}', '{{ $thursday->description }}')"/>
                                            <input type="button" class="btn btn-danger" value="Apagar" onclick="if (confirm('Excluir a programação selecionada?')) { $('#delete_{{ $thursday->id }}').submit(); }" />
                                            <form action="{{ route('admin.schedule.destroy', $thursday->id) }}" method="post" id="delete_{{ $thursday->id }}" hidden>
                                                @csrf
                                                @method('DELETE')
                                            </form>
                                        </td>
                                    </tr>
                                    @endforeach
                                    
                                </tbody>

                            </table>
                        </div>


                        <div id="sexta" class="tab-pane {!! $action == 'friday' ? 'active' : '' !!}">
                            <table id="tabela_5" class="table table-bordered table-hover">

                                <thead>
                                    <tr>
                                        <th>Início</th>
                                        <th>Programa</th>
                                        <th></th>
                                    </tr>
                                </thead>

                                <tbody>
                                    
                                    @foreach($schedules->friday as $friday)
                                    <tr>												
                                        <td onclick="" style="cursor:pointer;"> {{ $friday->start_time  }}</td>
                                        <td onclick="">{{ $friday->name }}</td>
                                        <td>
                                            <input type="button" class="btn btn-primary" value="Editar" onclick="openModalEdit({{ $friday->id }}, '{{ $friday->day_the_week }}', '{{ $friday->start_time }}', '{{ $friday->name }}', '{{ $friday->presenter }}', '{{ $friday->description }}')"/>
                                            <input type="button" class="btn btn-danger" value="Apagar" onclick="if (confirm('Excluir a programação selecionada?')) { $('#delete_{{ $friday->id }}').submit(); }" />
                                            <form action="{{ route('admin.schedule.destroy', $friday->id) }}" method="post" id="delete_{{ $friday->id }}" hidden>
                                                @csrf
                                                @method('DELETE')
                                            </form>
                                        </td>
                                    </tr>
                                    @endforeach
                                    
                                </tbody>

                            </table>
                        </div>


                        <div id="sabado" class="tab-pane {!! $action == 'saturday' ? 'active' : '' !!}">
                            <table id="tabela_6" class="table table-bordered table-hover">

                                <thead>
                                    <tr>
                                        <th>Início</th>
                                        <th>Programa</th>
                                        <th></th>
                                    </tr>
                                </thead>

                               
                                <tbody>
                                    
                                    @foreach($schedules->saturday as $saturday)
                                    <tr>												
                                        <td onclick="" style="cursor:pointer;"> {{ $saturday->start_time  }}</td>
                                        <td onclick="">{{ $saturday->name }}</td>
                                        <td>
                                            <input type="button" class="btn btn-primary" value="Editar" onclick="openModalEdit({{ $saturday->id }}, '{{ $saturday->day_the_week }}', '{{ $saturday->start_time }}', '{{ $saturday->name }}', '{{ $saturday->presenter }}', '{{ $saturday->description }}')"/>
                                            <input type="button" class="btn btn-danger" value="Apagar" onclick="if (confirm('Excluir a programação selecionada?')) { $('#delete_{{ $saturday->id }}').submit(); }" />
                                            <form action="{{ route('admin.schedule.destroy', $saturday->id) }}" method="post" id="delete_{{ $saturday->id }}" hidden>
                                                @csrf
                                                @method('DELETE')
                                            </form>
                                        </td>
                                    </tr>
                                    @endforeach
                                    
                                </tbody>

                            </table>
                        </div>


                        
                    </div>							

                </div>
                
            </div>
            <!-- /.row -->
            
        </div>
    </section>
        <!-- /.content -->

    </div>

    @include('admin.footer')

    <script>
        function enableSchedule(){
            $('#enable').prop( "disabled", true );
            $.ajax({
                headers: {
                        'X-CSRF-Token': "{{ csrf_token() }}",
                },
                type: 'PUT',
                url: "{{ route('admin.schedule.update') }}",
                data: { 
                    enable: $('#enable').is(':checked')
                },
                enctype: 'multipart/form-data',
                success: function(data){
                    $('#enable').prop( "disabled", false );
                },
                error: function(data){
                    $('#enable').prop( "disabled", false );
                    console.log('Erro no Ajax !');
                }
            });
        }
        function openModalCreate(){
            $("#create").modal();
        }
        function openModalEdit(id, day_the_week, start_time, name, presenter, description){
            $('#id_schedule').val(id);
            $('#day_the_week').val(day_the_week);
            $('#start_time').val(start_time);
            $('#name').val(name);
            $('#presenter').val(presenter);
            $('#description').val(description);
            $("#update").modal();
        }
    </script>
<div id="create" class="modal fade" role="dialog">
   <div class="modal-dialog modal-md">
      <!-- Modal content-->
      <div class="modal-content" id="conteudo_modal">
         <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal">×</button>
            <h5 class="modal-title modal_titulo">Nova programação</h5>
         </div>
         <div class="modal-body" id="modal_conteudo_m">
            <style type="text/css">
               .bootstrap-timepicker-widget table{
               background-color: #fff !important;
               }
            </style>
            <form action="{{ route('admin.schedule.store') }}" class="form-horizontal" method="post">
                @csrf
                @method('POST')
               <fieldset>
                  <div class="form-group">
                     <label class="col-md-12">Dia da Semana</label>
                     <div class="col-md-6">
                        <select name="day_the_week" class="form-control select2" style="width: 100%;">
                           <option value="sunday" selected="">Domingo</option>
                           <option value="monday">Segunda</option>
                           <option value="tuesday">Terça</option>
                           <option value="wednesday">Quarta</option>
                           <option value="thursday">Quinta</option>
                           <option value="friday">Sexta</option>
                           <option value="saturday">Sábado</option>
                        </select>
                     </div>
                  </div>
                  <div class="form-group">
                     <label class="col-md-12">Início</label>
                     <div class="col-md-6">
                        <div class="bootstrap-timepicker">
                           <div class="bootstrap-timepicker-widget dropdown-menu">
                              <table>
                                 <tbody>
                                    <tr>
                                       <td><a href="#" data-action="incrementHour"><i class="glyphicon glyphicon-chevron-up"></i></a></td>
                                       <td class="separator">&nbsp;</td>
                                       <td><a href="#" data-action="incrementMinute"><i class="glyphicon glyphicon-chevron-up"></i></a></td>
                                    </tr>
                                    <tr>
                                       <td><span class="bootstrap-timepicker-hour">00</span></td>
                                       <td class="separator">:</td>
                                       <td><span class="bootstrap-timepicker-minute">00</span></td>
                                    </tr>
                                    <tr>
                                       <td><a href="#" data-action="decrementHour"><i class="glyphicon glyphicon-chevron-down"></i></a></td>
                                       <td class="separator"></td>
                                       <td><a href="#" data-action="decrementMinute"><i class="glyphicon glyphicon-chevron-down"></i></a></td>
                                    </tr>
                                 </tbody>
                              </table>
                           </div>
                           <div class="input-group">
                              <input type="text" class="form-control timepicker" name="start_time" value="00:00"/>
                              <div class="input-group-addon">
                                 <i class="fa fa-clock-o"></i>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
                  <div class="form-group">
                     <label class="col-md-12">Nome do Programa</label>
                     <div class="col-md-12">
                        <input name="name" type="text" class="form-control">
                     </div>
                  </div>
                  <div class="form-group">
                     <label class="col-md-12">Apresentador</label>
                     <div class="col-md-12">
                        <input name="presenter" type="text" class="form-control">
                     </div>
                  </div>
                  <div class="form-group">
                     <label class="col-md-12">Descrição</label>
                     <div class="col-md-12">
                        <textarea name="description" type="text" class="form-control" style="height:120px;"></textarea>
                     </div>
                  </div>
                  <div style="text-align: left; width: 100%;">
                     <button type="submit" class="btn btn-primary">Salvar</button>
                  </div>
               </fieldset>
            </form>
            <script type="text/javascript">
               $(document).ready(function() {
               
                 $('.timepicker').timepicker({
                   showInputs: false,
                   showMeridian: false
                 });
               
               });
            </script>
         </div>
         <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Fechar</button>
         </div>
      </div>
   </div>
</div>

<div id="update" class="modal fade" role="dialog">
    <div class="modal-dialog modal-md">
       <!-- Modal content-->
       <div class="modal-content" id="conteudo_modal">
          <div class="modal-header">
             <button type="button" class="close" data-dismiss="modal">×</button>
             <h5 class="modal-title modal_titulo">Editar programação</h5>
          </div>
          <div class="modal-body" id="modal_conteudo_m">
             <style type="text/css">
                .bootstrap-timepicker-widget table{
                background-color: #fff !important;
                }
             </style>
             <form action="{{ route('admin.schedule.update') }}" class="form-horizontal" method="post">
                 @csrf
                 @method('PUT')
                 <input type="id_schedule" name="id_schedule" id="id_schedule" hidden />
                <fieldset>
                   <div class="form-group">
                      <label class="col-md-12">Dia da Semana</label>
                      <div class="col-md-6">
                         <select name="day_the_week" id="day_the_week" class="form-control select2" style="width: 100%;">
                            <option value="sunday" selected="">Domingo</option>
                            <option value="monday">Segunda</option>
                            <option value="tuesday">Terça</option>
                            <option value="wednesday">Quarta</option>
                            <option value="thursday">Quinta</option>
                            <option value="friday">Sexta</option>
                            <option value="saturday">Sábado</option>
                         </select>
                      </div>
                   </div>
                   <div class="form-group">
                      <label class="col-md-12">Início</label>
                      <div class="col-md-6">
                         <div class="bootstrap-timepicker">
                            <div class="bootstrap-timepicker-widget dropdown-menu">
                               <table>
                                  <tbody>
                                     <tr>
                                        <td><a href="#" data-action="incrementHour"><i class="glyphicon glyphicon-chevron-up"></i></a></td>
                                        <td class="separator">&nbsp;</td>
                                        <td><a href="#" data-action="incrementMinute"><i class="glyphicon glyphicon-chevron-up"></i></a></td>
                                     </tr>
                                     <tr>
                                        <td><span class="bootstrap-timepicker-hour">00</span></td>
                                        <td class="separator">:</td>
                                        <td><span class="bootstrap-timepicker-minute">00</span></td>
                                     </tr>
                                     <tr>
                                        <td><a href="#" data-action="decrementHour"><i class="glyphicon glyphicon-chevron-down"></i></a></td>
                                        <td class="separator"></td>
                                        <td><a href="#" data-action="decrementMinute"><i class="glyphicon glyphicon-chevron-down"></i></a></td>
                                     </tr>
                                  </tbody>
                               </table>
                            </div>
                            <div class="input-group">
                               <input type="text" class="form-control timepicker" name="start_time" id="start_time" value="00:00"/>
                               <div class="input-group-addon">
                                  <i class="fa fa-clock-o"></i>
                               </div>
                            </div>
                         </div>
                      </div>
                   </div>
                   <div class="form-group">
                      <label class="col-md-12">Nome do Programa</label>
                      <div class="col-md-12">
                         <input name="name" id="name" type="text" class="form-control">
                      </div>
                   </div>
                   <div class="form-group">
                      <label class="col-md-12">Apresentador</label>
                      <div class="col-md-12">
                         <input name="presenter" id="presenter" type="text" class="form-control">
                      </div>
                   </div>
                   <div class="form-group">
                      <label class="col-md-12">Descrição</label>
                      <div class="col-md-12">
                         <textarea name="description" id="description" type="text" class="form-control" style="height:120px;"></textarea>
                      </div>
                   </div>
                   <div style="text-align: left; width: 100%;">
                      <button type="submit" class="btn btn-primary">Salvar</button>
                   </div>
                </fieldset>
             </form>
             <script type="text/javascript">
                $(document).ready(function() {
                
                  $('.timepicker').timepicker({
                    showInputs: false,
                    showMeridian: false
                  });
                
                });
             </script>
          </div>
          <div class="modal-footer">
             <button type="button" class="btn btn-default" data-dismiss="modal">Fechar</button>
          </div>
       </div>
    </div>
 </div>