<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

/*
Route::prefix('posts')->group(function() {
    Route::get('/', 'PostsController@index');
});
*/

Route::group(['middleware' => 'auth'], function () {
    Route::get('/admin/posts', '\Modules\Posts\Http\Controllers\PostsAdminController@index')->name('admin.posts.index');
    Route::get('/admin/posts/create', '\Modules\Posts\Http\Controllers\PostsAdminController@create')->name('admin.posts.create');
    Route::get('/admin/posts/edit/{id}', '\Modules\Posts\Http\Controllers\PostsAdminController@edit')->name('admin.posts.edit');
    Route::post('/admin/posts/store', '\Modules\Posts\Http\Controllers\PostsAdminController@store')->name('admin.posts.store');
    Route::delete('/admin/posts/delete/{id}', '\Modules\Posts\Http\Controllers\PostsAdminController@destroy')->name('admin.posts.destroy');
    Route::put('/admin/posts/update/{id}', '\Modules\Posts\Http\Controllers\PostsAdminController@update')->name('admin.posts.update');

    Route::delete('/admin/category/delete/{id}', '\Modules\Posts\Http\Controllers\CategoriesAdminController@destroy')->name('admin.categories.destroy');
    Route::post('/admin/category/store', '\Modules\Posts\Http\Controllers\CategoriesAdminController@store')->name('admin.categories.store');
    Route::put('/admin/category/update', '\Modules\Posts\Http\Controllers\CategoriesAdminController@update')->name('admin.categories.update');

    Route::post('/admin/posts/upload', '\Modules\Posts\Http\Controllers\PostsAdminController@upload')->name('admin.posts.upload');

    Route::put('/admin/poststext/update/{type}', '\Modules\Posts\Http\Controllers\PostsTextsController@update')->name('admin.poststext.update');
});

Route::get('/posts/{id}', '\Modules\Posts\Http\Controllers\PostsController@show')->name('posts.show');