<?php

namespace Modules\Posts\Http\Controllers;

use stdClass;
use Illuminate\Http\Request;
use Modules\Core\Entities\Colors;
use Modules\Posts\Entities\Posts;
use Illuminate\Routing\Controller;
use Modules\Core\Entities\Menuses;
use Modules\Layout\Entities\Layouts;
use Modules\Stream\Entities\Streams;
use Modules\Settings\Entities\Settings;
use Illuminate\Contracts\Support\Renderable;

class PostsController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        return view('posts::index');
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        return view('posts::create');
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {

        $settings = Settings::first();
        $colors = Colors::first();
        $headers = Menuses::where('enable', true)->where('type', 'header')->orderBy('order')->get();
        $footers = Menuses::where('enable', true)->where('type', 'footer')->orderBy('order')->get();
        $stream = Streams::first();

        $layout = new stdClass();
        $layout->favicon = Layouts::where('type', 'favicon')->first();
        $layout->header = Layouts::where('type', 'header')->first();
        $layout->footer = Layouts::where('type', 'footer')->first();
        $layout->facebook = Layouts::where('type', 'facebook')->first();
        $layout->instagram = Layouts::where('type', 'instagram')->first();
        $layout->whatsapp = Layouts::where('type', 'whatsapp')->first();
        $layout->slides = Layouts::where('type', 'slide')->get();

        $post = Posts::where('id', $id)->first();
        

        return view('posts::show',
            [
                'settings' => $settings,
                'colors' => $colors,
                'layout' => $layout,
                'footers' => $footers,
                'stream' => $stream,
                'headers' => $headers,
                'post' => $post
            ]
        );
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        return view('posts::edit');
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        //
    }
}
