<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

/*
Route::prefix('polls')->group(function() {
    Route::get('/', 'PollsController@index');
});
*/

Route::group(['middleware' => 'auth'], function () {
    Route::get('/admin/polls', '\Modules\Polls\Http\Controllers\PollsAdminController@index')->name('admin.polls.index');
    Route::post('/admin/polls/store', '\Modules\Polls\Http\Controllers\PollsAdminController@store')->name('admin.polls.store');
    Route::put('/admin/polls/update', '\Modules\Polls\Http\Controllers\PollsAdminController@update')->name('admin.polls.update');
    Route::put('/admin/polls/texts/update', '\Modules\Polls\Http\Controllers\PollsTextsController@update')->name('admin.polls.texts.update');
    Route::delete('/admin/polls/delete/{id}', '\Modules\Polls\Http\Controllers\PollsAdminController@destroy')->name('admin.polls.destroy');
});

Route::post('/polls/store', '\Modules\Polls\Http\Controllers\PollsController@store')->name('polls.store');
