@include('admin.header', [
   'elementActive' => 'polls'
])

<div class="content-wrapper">

    <section class="content-header">
      <h1>
      Enquetes	      <small>Crie uma nova enquete para que seus ouvintes possam responder</small>
      </h1> 
    </section>

    <!-- Main content -->
    <section class="content">
    <div class="row">
        <div class="col-xs-12">   
            <div class="nav-tabs-custom">
                <ul class="nav nav-tabs ">
                   <li {!! $active == 'polls' || $active == false ? 'class="active"' : '' !!}  >
                      <a href="#polls" data-toggle="tab">Enquetes</a>
                   </li>
                   <li {!! $active == 'texts' ? 'class="active"' : '' !!}>
                      <a href="#texts" data-toggle="tab">Textos</a>
                   </li>
                </ul>
                
                <div class="tab-content">
                   <div id="polls" class="tab-pane {!! $active == 'polls' || $active == false ? 'active' : '' !!}">
          <form method="post" id="form_apagar" name="form_apagar">

            <!-- box -->
            <div class="box">
                <div class="box-body">

                    <div style="text-align:left;">

                        <button type="button" class="btn btn-primary" onclick="openModalCreate();">Novo</button>
                        <br/>
                        <br/>
                        <form class="form-group">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="enable" id="enable" {{ $enable ? 'checked' : '' }} onclick="enablePolls()" id="flexCheckDefault">
                                <label class="form-check-label" for="flexCheckDefault">
                                  Habilitar enquetes
                                </label>
                              </div>
                        </form>
                        
                    </div>

                    

                    <div id="tabela1_wrapper" class="dataTables_wrapper form-inline dt-bootstrap no-footer">
                        
                        <div class="row">
                            <div class="col-sm-12">
                                        
                                <table class="table table-bordered table-striped">
                        
                                    <thead>
                                        <tr>
                                   
                                            
                                            <th>Titulo</th>
                                            <th>Imagem</th>
                                            <th>Ativo</th>
                                            <th>Opt.</th>
                                        </tr>
                                    </thead>
                                    
                                    <tbody id="sortable" class="ui-sortable">
                                    
                                        @foreach ($polls as $poll)
                                            <tr id="item_22">
                                                
                                                <td>{{ $poll->question }}</td>
                                                <td><img src="{{ asset($poll->image) }}" width="80px"/></td>
                                                <td><input type="radio" name="active" id="active" {{ $poll->active ? 'checked' : '' }} onclick="activePoll({{ $poll->id }})" value="{{ $poll->id }}"/></td>
            
                                                <td>
                                                    <input type="button" class="btn btn-primary" value="Analisar" onclick="openModalEdit({{ $poll->id }}, '{{ $poll->question }}', '{{ asset($poll->image) }}', {{ $poll->options }})"/>
                                                    <input type="button" class="btn btn-danger" value="Apagar" onclick="if (confirm('Excluir enquete selecionada?')) { $('#delete_{{ $poll->id }}').submit(); }" />
                                                    <form action="{{ route('admin.polls.destroy', $poll->id) }}" method="post" id="delete_{{ $poll->id }}" hidden>
                                                        @csrf
                                                        @method('DELETE')
                                                    </form>
            
                                                </td>
                                            </tr>
                                        @endforeach
                                            
                                                                        </tbody>
            
                                </table>
                            
                            
                            </div></div>
                            <div class="col-12">
                                <div class="col-12 text-right">
                                   {!! $polls->links("pagination::bootstrap-4") !!}
        
                                </div>
                            </div>
                        </div>

                </div>

            </div>
            <!-- /.box -->

        </form>
        </div>
        <div id="texts" class="tab-pane {!! $active == 'texts' ? 'active' : '' !!}">
            <form action="{{ route('admin.polls.texts.update') }}" class="form-horizontal" method="post">
                @csrf
                @method('PUT')
            <fieldset>
                <div class="form-group">
                   <label class="col-md-12">Titulo</label>
                   <div class="col-md-7">
                      <input name="title" value="{{ $pollstexts->title }}" type="text" class="form-control">
                   </div>
                </div>
                <div class="form-group">
                   <label class="col-md-12">Mmensagem</label>
                   <div class="col-md-7">
                      <textarea class="form-control" name="message">{{ $pollstexts->message  }}</textarea>
                   </div>
                </div>
             </fieldset>
             <div>
                <button type="submit" class="btn btn-primary">Salvar</button>
             </div>
            </form>
        </div>
        </div>

        </div>
        </div>

    </div>
    <!-- /.row -->
</section>
<!-- /.content -->

</div>
@include('admin.footer')



<script>
     function activePoll(id){
        $('#active').prop( "disabled", true );
        $.ajax({
            headers: {
                    'X-CSRF-Token': "{{ csrf_token() }}",
            },
            type: 'PUT',
            url: "{{ route('admin.polls.update') }}",
            data: { 
                active: id
            },
            enctype: 'multipart/form-data',
            success: function(data){
                $('#active').prop( "disabled", false );
            },
            error: function(data){
                $('#active').prop( "disabled", false );
                console.log('Erro no Ajax !');
            }
        });
    }
    function enablePolls   (){
        $('#enable').prop( "disabled", true );
        $.ajax({
            headers: {
                    'X-CSRF-Token': "{{ csrf_token() }}",
            },
            type: 'PUT',
            url: "{{ route('admin.polls.update') }}",
            data: { 
                enable: $('#enable').is(':checked')
            },
            enctype: 'multipart/form-data',
            success: function(data){
                $('#enable').prop( "disabled", false );
            },
            error: function(data){
                $('#enable').prop( "disabled", false );
                console.log('Erro no Ajax !');
            }
        });
    }
    function openModalCreate(){
        $('#question').val('');
        $("#create").modal();
    }
    function openModalEdit(id, question, image, options){
  
        $('#id_poll').val(id);
        $('#question').html(question);
        $("#image").attr("src",image);


        var options_html = '<ul>';

        $.each( options, function( key, value ) {
            console.log( key + ": " + value.answer);

            options_html = options_html + '<li>' + value.answer + ' - ' + value.total_votes + ' votos</li>';
        });

        options_html = options_html + '</ul>';

        $('#options').html(options_html);
        
        $("#update").modal();
    }
</script>

<div id="update" class="modal fade" role="dialog">
    <div class="modal-dialog modal-md">
       <!-- Modal content-->
       <div class="modal-content" id="conteudo_modal">
          <div class="modal-header">
             <button type="button" class="close" data-dismiss="modal">×</button>
             <h5 class="modal-title modal_titulo">Veja as respostas da enquete</h5>
          </div>
          <div class="modal-body" id="modal_conteudo_m">
             <style type="text/css">
                .bootstrap-timepicker-widget table{
                background-color: #fff !important;
                }
             </style>
             <form class="form-horizontal" method="post" enctype="multipart/form-data">
                 @csrf
                 @method('PUT')
                 <input type="text" name="id_poll" id="id_poll" hidden />

                 <div class="form-group">
                    <div class="col-md-12">
                       <center><img id="image" src="" width="300px"/></center>
                    </div>
                </div>
                <fieldset>
                   <div class="form-group">

                      <div class="col-md-12">
                         <h3><span name="question" id="question"></span></h3>
                      </div>
                   </div>

                   <div id="options">

                   </div>
                   
                   
                </fieldset>
             </form>
          </div>
          <div class="modal-footer">
             <button type="button" class="btn btn-default" data-dismiss="modal">Fechar</button>
          </div>
       </div>
    </div>
    </div>
<div id="create" class="modal fade" role="dialog">
    <div class="modal-dialog modal-md">
       <!-- Modal content-->
       <div class="modal-content" id="conteudo_modal">
          <div class="modal-header">
             <button type="button" class="close" data-dismiss="modal">×</button>
             <h5 class="modal-title modal_titulo">Adicione uma nova enquete</h5>
          </div>
          <div class="modal-body" id="modal_conteudo_m">
             <style type="text/css">
                .bootstrap-timepicker-widget table{
                background-color: #fff !important;
                }
             </style>
             <form action="{{ route('admin.polls.store') }}" class="form-horizontal" method="post" enctype="multipart/form-data">
                 @csrf
                 @method('POST')
                <fieldset>
                   <div class="form-group">
                      <label class="col-md-12">Questão da enquete</label>
                      <div class="col-md-12">
                         <input name="question" id="question" type="text" class="form-control">
                      </div>
                   </div>

                   <div class="form-group">
                        <label class="col-md-12">Resposta 1</label>
                        <div class="col-md-12">
                        <input name="option_1" id="option_1" type="text" class="form-control">
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-md-12">Resposta 2</label>
                        <div class="col-md-12">
                        <input name="option_2" id="option_2" type="text" class="form-control">
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-md-12">Resposta 3</label>
                        <div class="col-md-12">
                        <input name="option_3" id="option_3" type="text" class="form-control">
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-md-12">Resposta 4</label>
                        <div class="col-md-12">
                        <input name="option_4" id="option_4" type="text" class="form-control">
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-md-12">Resposta 5</label>
                        <div class="col-md-12">
                        <input name="option_5" id="option_5" type="text" class="form-control">
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-md-12">Resposta 6</label>
                        <div class="col-md-12">
                        <input name="option_6" id="option_6" type="text" class="form-control">
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-md-12">Resposta 7</label>
                        <div class="col-md-12">
                        <input name="option_7" id="option_7" type="text" class="form-control">
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-md-12">Resposta 8</label>
                        <div class="col-md-12">
                        <input name="option_8" id="option_8" type="text" class="form-control">
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-md-12">Resposta 9</label>
                        <div class="col-md-12">
                        <input name="option_9" id="option_9" type="text" class="form-control">
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="col-md-12">
                           <fieldset> 
                              <label>Imagem</label> 
                              <div class="fileupload fileupload-new" data-provides="fileupload">
                                  <div class="input-append">
                                    <div class="uneditable-input">
                                      <i class="fa fa-file fileupload-exists"></i>
                                      <span class="fileupload-preview"></span>
                                    </div>
                                    <span class="btn btn-default btn-file">
                                    <span class="fileupload-exists">Alterar</span>
                                    <span class="fileupload-new">Procurar arquivo</span>
                                      <input type="file" name="file">
                                    </span>
                                    <a href="#" class="btn btn-default fileupload-exists" data-dismiss="fileupload">Remover</a>
                                  </div>
                              </div>
                            </fieldset>
                            <br>   
                            <span style="color: #ff0000;"><strong>Tamanho ideal: Largura 578 x Altura 279</strong></span>
                        </div>
                     </div>

                   <div style="text-align: left; width: 100%;">
                      <button type="submit" class="btn btn-primary">Salvar</button>
                   </div>
                </fieldset>
             </form>
             <script type="text/javascript">
                $(document).ready(function() {
                
                  $('.timepicker').timepicker({
                    showInputs: false,
                    showMeridian: false
                  });
                
                });
             </script>
          </div>
          <div class="modal-footer">
             <button type="button" class="btn btn-default" data-dismiss="modal">Fechar</button>
          </div>
       </div>
    </div>
    </div>