<?php

namespace Modules\Polls\Http\Controllers;

use Illuminate\Http\Request;
use Modules\Polls\Entities\Polls;
use Illuminate\Routing\Controller;
use Modules\Polls\Entities\PollOptions;
use Illuminate\Contracts\Support\Renderable;

class PollsController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        return view('polls::admin.index');
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        return view('polls::create');
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        $data = $request->all();

        if(!isset($data['answer'])){
            return array(
                'success' => false,
                'message' => 'Selecione uma opção!'
            );
        }

        $answer = $data['answer'];

        $polloptions = PollOptions::where('id', $answer)->first();

        
        $polloptions->total_votes = $polloptions->total_votes + 1;

        $polloptions->save();

        $poll = Polls::where('id', $polloptions->id_poll)->first();

        $poll->total_votes = $poll->total_votes + 1;

        $poll->save();


        $polloptions = PollOptions::where('id_poll', $poll->id)->get();

        $result = '<div class="enquete_pergunta"><b>'.$poll->question.'</b></div>

                    <div style="padding-bottom: 50px; ">';
                        
                    foreach($polloptions as $option){
                        
                        $result .= '<div class="enquete_resposta" style="margin-top:20px;">
                        <label for="resposta_158448292791233">'.$option->answer.'</label>
                        <div style="font-size:14px;">'.number_format(($option->total_votes * 100 / $poll->total_votes), 2, '.', '').' % dos votos</div>
                        <div style="margin-top:5px; width:'.number_format(($option->total_votes * 100 / $poll->total_votes), 2, '.', '').'%; height:5px; background-color:#000;"></div>
                      </div>';
                    }
                    

        $result .= '</div>';


        return array(
            'success' => true,
            'message' => 'Voto computado com sucesso!',
            'result' => $result
        );

    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('polls::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        return view('polls::edit');
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        //
    }
}
