<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePollsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('polls', function (Blueprint $table) {
            $table->id();
            $table->string('question');
            $table->integer('total_votes')->default(0);
            $table->string('image')->default('storage/img/polls/default.jpg');
            $table->boolean('active')->default(false);
            $table->boolean('enable')->default(true);
            $table->timestamps();
        });

        DB::table('polls')->insert(['question' => 'O que você achou de nosso Site?', 'total_votes' => '100', 'active' => true, 'created_at' => now(), 'updated_at' => now()]);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('polls');
    }
}
