<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

/*
Route::prefix('photos')->group(function() {
    Route::get('/', 'PhotosController@index');
});
*/


Route::group(['middleware' => 'auth'], function () {
    Route::get('/admin/photos', '\Modules\Photos\Http\Controllers\PhotosAdminController@index')->name('admin.photos.index');
    Route::delete('/admin/photos/delete/{id}', '\Modules\Photos\Http\Controllers\PhotosAdminController@destroy')->name('admin.photos.destroy');
    Route::post('/admin/photos/store', '\Modules\Photos\Http\Controllers\PhotosAdminController@store')->name('admin.photos.store');
    Route::put('/admin/photos/update', '\Modules\Photos\Http\Controllers\PhotosAdminController@update')->name('admin.photos.update');

    Route::put('/admin/photos/texts/update', '\Modules\Photos\Http\Controllers\PhotosTextsController@update')->name('admin.photos.texts.update');
});
