<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateLayoutsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('layouts', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('type');
            $table->string('description');
            $table->string('image');
            $table->timestamps();
        });

        DB::table('layouts')->insert(['name' => 'Ícone', 'description' => 'Essa é o Ícone do rádio (500x100)', 'type'=> 'favicon', 'image' => 'storage/img/layouts/2131326151651651651321.png']);
        DB::table('layouts')->insert(['name' => 'Logo início', 'description' => 'Essa é a logo que aparece no todo do site (500x100)', 'type'=> 'header', 'image' => 'storage/img/layouts/435644234693461332417.png']);
        DB::table('layouts')->insert(['name' => 'Logo do rodapé', 'description' => 'Essa é a logo que aparece no rodapé do site (500x100)', 'type'=> 'footer', 'image' => 'storage/img/layouts/2645187659446313322147365.png']);
        DB::table('layouts')->insert(['name' => 'Logo do gerenciador', 'description' => 'Essa é a logo que aparece no topo do gerenciador (500x100)', 'type'=> 'footer', 'image' => 'storage/img/layouts/56434654657426412772565485.png']);
        DB::table('layouts')->insert(['name' => 'Facebook', 'description' => 'Essa é a logo do facebook (250x250)', 'type'=> 'facebook', 'image' => 'storage/img/layouts/34320534134621055.png']);
        DB::table('layouts')->insert(['name' => 'Instagram', 'description' => 'Essa é a logo do Instagram (250x250)', 'type'=> 'instagram', 'image' => 'storage/img/layouts/3451633407343217.png']);
        DB::table('layouts')->insert(['name' => 'Whatsapp', 'description' => 'Essa é a logo do Whatsapp (250x250)', 'type'=> 'whatsapp', 'image' => 'storage/img/layouts/545103241230332712.png']);
        DB::table('layouts')->insert(['name' => 'Slide 1', 'description' => 'Esse é o primeiro slide que aparece no site (1920x1000)', 'type'=> 'slide', 'image' => 'storage/img/layouts/15213361381653281343218.jpg']);
        DB::table('layouts')->insert(['name' => 'Slide 2', 'description' => 'Esse é o segundo slide que aparece no site (1920x1000)', 'type'=> 'slide', 'image' => 'storage/img/layouts/56351463341732341731.jpg']);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('layouts');
    }
}
