@include('admin.header', [
   'elementActive' => 'events'
])

<div class="content-wrapper">

    <section class="content-header">
      <h1>
      Events	      <small> Adicione eventos em seu WebSite</small>
      </h1> 
    </section>

    <!-- Main content -->
    <section class="content">
    <div class="row">
        
        <div class="col-xs-12">   
           
         <div class="nav-tabs-custom">
            <ul class="nav nav-tabs ">
               <li {!! $active == 'events' || $active == false ? 'class="active"' : '' !!}  >
                  <a href="#events" data-toggle="tab">Eventos</a>
               </li>
               <li {!! $active == 'texts' ? 'class="active"' : '' !!}>
                  <a href="#texts" data-toggle="tab">Textos</a>
               </li>
            </ul>

            <div class="tab-content">
               <div id="events" class="tab-pane {!! $active == 'events' || $active == false ? 'active' : '' !!}">
          <form action="" method="post" id="form_apagar" name="form_apagar">

            <!-- box -->
            <div class="box">
                <div class="box-body">

                    <div style="text-align:left;">

                        <button type="button" class="btn btn-primary" onclick="openModalCreate()">Novo</button>

                    </div>		
                    <br/>         
                    <form class="form-group">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="enable" id="enable" {{ $enable ? 'checked' : '' }} onclick="enableEvents()" id="flexCheckDefault">
                            <label class="form-check-label" for="flexCheckDefault">
                              Habilitar eventos
                            </label>
                          </div>
                        </form>

                  

                    <table class="table table-bordered table-striped">

                        <thead>
                            <tr>
                                <th>Titulo</th>
                                <th>Opt.</th>
                            </tr>
                        </thead>
                        
                        <tbody>
                        
                            @foreach ($events as $event)
                            <tr id="{{ $event->id }}">
                                <td style="cursor:pointer;">{{ $event->title }}</td>
                                <td>

                                    <input type="button" class="btn btn-primary" value="Editar" onclick="openModalEdit({{ $event->id }}, '{{ $event->title }}', '{{ $event->description }}')"/>
                                    <input type="button" class="btn btn-danger" value="Apagar" onclick="if (confirm('Excluir o colaborador selecionado?')) { $('#delete_{{ $event->id }}').submit(); }" />
                                    <form action="{{ route('admin.events.destroy', $event->id) }}" method="post" id="delete_{{ $event->id }}" hidden>
                                        @csrf
                                        @method('DELETE')
                                    </form>

                                </td>
                            </tr>
                            @endforeach
                                
                                
                        </tbody>

                    </table>

                    <div class="col-12">
                     <div class="col-12 text-right">
                        {!! $events->links("pagination::bootstrap-4") !!}

                     </div>
                 </div>

                </div>

            </div>
            <!-- /.box -->

        </form>
      </div>
      <div id="texts" class="tab-pane {!! $active == 'texts' ? 'active' : '' !!}">
         <form action="{{ route('admin.events.texts.update') }}" class="form-horizontal" method="post">
             @csrf
             @method('PUT')
         <fieldset>
             <div class="form-group">
                <label class="col-md-12">Titulo</label>
                <div class="col-md-7">
                   <input name="title" value="{{ $evetnstexts->title }}" type="text" class="form-control">
                </div>
             </div>
             <div class="form-group">
                <label class="col-md-12">Mmensagem</label>
                <div class="col-md-7">
                   <textarea class="form-control" name="message">{{ $evetnstexts->message  }}</textarea>
                </div>
             </div>
          </fieldset>
          <div>
             <button type="submit" class="btn btn-primary">Salvar</button>
          </div>
         </form>
     </div>
      </div>
        </div>

    </div>
    <!-- /.row -->
</section>
<!-- /.content -->

</div>
@include('admin.footer')





<script>
    function enableEvents(){
        $('#enable').prop( "disabled", true );
        $.ajax({
            headers: {
                    'X-CSRF-Token': "{{ csrf_token() }}",
            },
            type: 'PUT',
            url: "{{ route('admin.events.update') }}",
            data: { 
                enable: $('#enable').is(':checked')
            },
            enctype: 'multipart/form-data',
            success: function(data){
                $('#enable').prop( "disabled", false );
            },
            error: function(data){
                $('#enable').prop( "disabled", false );
                console.log('Erro no Ajax !');
            }
        });
    }
    function openModalCreate(){
        $('#title').val('');
        $('#description').val('');

        $("#create").modal();
    }
    function openModalEdit(id, title, description){
        $('#id_event').val(id);
        $('#title').val(title);
        $('#description').val(description);

        $("#update").modal();
    }
</script>

<div id="update" class="modal fade" role="dialog">
    <div class="modal-dialog modal-md">
       <!-- Modal content-->
       <div class="modal-content" id="conteudo_modal">
          <div class="modal-header">
             <button type="button" class="close" data-dismiss="modal">×</button>
             <h5 class="modal-title modal_titulo">Editar anúncio</h5>
          </div>
          <div class="modal-body" id="modal_conteudo_m">
             <style type="text/css">
                .bootstrap-timepicker-widget table{
                background-color: #fff !important;
                }
             </style>
             <form action="{{ route('admin.events.update') }}" class="form-horizontal" method="post" enctype="multipart/form-data">
                 @csrf
                 @method('PUT')
                 <input type="text" name="id_event" id="id_event" hidden />
                <fieldset>
                   <div class="form-group">
                      <label class="col-md-12">Título</label>
                      <div class="col-md-12">
                         <input name="title" id="title" type="text" class="form-control">
                      </div>
                   </div>
                   <div class="form-group">
                      <label class="col-md-12">Descrição</label>
                      <div class="col-md-12">
                         <textarea name="description" id="description" class="form-control"></textarea>
                      </div>
                   </div>
  
                   <div style="text-align: left; width: 100%;">
                      <button type="submit" class="btn btn-primary">Salvar</button>
                   </div>
                </fieldset>
             </form>
          </div>
          <div class="modal-footer">
             <button type="button" class="btn btn-default" data-dismiss="modal">Fechar</button>
          </div>
       </div>
    </div>
    </div>
<div id="create" class="modal fade" role="dialog">
    <div class="modal-dialog modal-md">
       <!-- Modal content-->
       <div class="modal-content" id="conteudo_modal">
          <div class="modal-header">
             <button type="button" class="close" data-dismiss="modal">×</button>
             <h5 class="modal-title modal_titulo">Adicionar evento</h5>
          </div>
          <div class="modal-body" id="modal_conteudo_m">
             <style type="text/css">
                .bootstrap-timepicker-widget table{
                background-color: #fff !important;
                }
             </style>
             <form action="{{ route('admin.events.store') }}" class="form-horizontal" method="post" enctype="multipart/form-data">
                 @csrf
                 @method('POST')
                <fieldset>
                   <div class="form-group">
                      <label class="col-md-12">Nome do evento</label>
                      <div class="col-md-12">
                         <input name="title" id="title" type="text" class="form-control">
                      </div>
                   </div>
                   <div class="form-group">
                      <label class="col-md-12">Descrição</label>
                      <div class="col-md-12">
                        <textarea name="description" id="description" class="form-control"></textarea>
                      </div>
                   </div>

                   <div style="text-align: left; width: 100%;">
                      <button type="submit" class="btn btn-primary">Salvar</button>
                   </div>
                </fieldset>
             </form>
          </div>
          <div class="modal-footer">
             <button type="button" class="btn btn-default" data-dismiss="modal">Fechar</button>
          </div>
       </div>
    </div>
    </div>


