<?php

namespace Modules\Emails\Http\Controllers;

use Response;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Emails\Entities\Emails;
use Illuminate\Support\Facades\Storage;
use Illuminate\Contracts\Support\Renderable;

class EmailsAdminController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        $enable = Emails::first();
        $emails = Emails::paginate(9);

        return view('emails::admin.index',
            [
                'enable' => isset($enable->enable) ? $enable->enable : false,
                'emails' => $emails
            ]
        );
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        return view('emails::admin.create');
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        $data = $request->all();

        $name = $data['name'];
        $email_user = $data['email'];

        $email = new Emails();

        $email->name = $name;
        $email->email = $email_user;

        $email->save();

        return redirect()->route('admin.emails.index');

    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('emails::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        return view('emails::edit');
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request)
    {
        $data = $request->all();

        $id_email = $data['id_email'];
        $name = $data['name'];
        $email_user = $data['email'];

        $email = Emails::where('id', $id_email)->first();

        $email->name = $name;
        $email->email = $email_user;

        $email->save();

        return redirect()->route('admin.emails.index');

    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        $email = Emails::where('id', $id)->first();

        if($email){
            $email->delete();
        }

        return redirect()->route('admin.emails.index');
    }

    public function export(){

        if(\File::exists(public_path('storage/exports/export.csv'))){

            \File::delete(public_path('storage/exports/export.csv'));
        
        }

        $emails = Emails::get();

        foreach($emails as $email){
            try {
                Storage::append('public/exports/export.csv', "$email->name, $email->email");
            } catch (\Exception $e) {
                
            }
        }        

        if(is_file(public_path('storage/exports/export.csv'))){
            return Response::download(public_path('storage/exports/export.csv'), 'export.csv', array('Content-Type: application/octet-stream','Content-Length: '. filesize(public_path('storage/exports/export.csv'))))->deleteFileAfterSend(true);
        }else{
            return redirect()->back()->with('failed', 'Falha ao baixar');  
        }
        
    }
}
