<?php

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMenusesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('menuses', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('type');
            $table->string('value');
            $table->integer('order');
            $table->boolean('enable')->default(true);
            $table->timestamps();
        });

        DB::table('menuses')->insert(['name' => 'INICIO', 'type' => 'header', 'value' => '/', 'order' => 1, 'enable' => true, 'created_at' => now(), 'updated_at' => now()]);
        DB::table('menuses')->insert(['name' => 'SOBRE', 'type' => 'header', 'value' => '#sobre', 'order' => 2, 'enable' => true, 'created_at' => now(), 'updated_at' => now()]);
        DB::table('menuses')->insert(['name' => 'PROGRAMAÇÃO', 'type' => 'header', 'value' => '#programacao', 'order' => 3, 'enable' => true, 'created_at' => now(), 'updated_at' => now()]);
        DB::table('menuses')->insert(['name' => 'EQUIPE', 'type' => 'header', 'value' => '#equipe', 'order' => 4, 'enable' => true, 'created_at' => now(), 'updated_at' => now()]);
        DB::table('menuses')->insert(['name' => 'FOTOS', 'type' => 'header', 'value' => '#galeria', 'order' => 5, 'enable' => true, 'created_at' => now(), 'updated_at' => now()]);
        DB::table('menuses')->insert(['name' => 'ENQUETE', 'type' => 'header', 'value' => '#enquete', 'order' => 6, 'enable' => true, 'created_at' => now(), 'updated_at' => now()]);
        DB::table('menuses')->insert(['name' => 'BLOG', 'type' => 'header', 'value' => '#blog', 'order' => 7, 'enable' => true, 'created_at' => now(), 'updated_at' => now()]);
        DB::table('menuses')->insert(['name' => 'CONTATO', 'type' => 'header', 'value' => '#faleconosco', 'order' => 8, 'enable' => false, 'created_at' => now(), 'updated_at' => now()]);

        DB::table('menuses')->insert(['name' => 'SOBRE NÓS', 'type' => 'footer', 'value' => '#', 'order' => 1, 'enable' => true, 'created_at' => now(), 'updated_at' => now()]);
        DB::table('menuses')->insert(['name' => 'PROGRAMAÇÃO', 'type' => 'footer', 'value' => '#programacao', 'order' => 2, 'enable' => true, 'created_at' => now(), 'updated_at' => now()]);
        DB::table('menuses')->insert(['name' => 'FAQ', 'type' => 'footer', 'value' => '#', 'order' => 3, 'enable' => true, 'created_at' => now(), 'updated_at' => now()]);
        DB::table('menuses')->insert(['name' => 'BLOG', 'type' => 'footer', 'value' => '#blog', 'order' => 4, 'enable' => true, 'created_at' => now(), 'updated_at' => now()]);
        DB::table('menuses')->insert(['name' => 'CONTATO', 'type' => 'footer', 'value' => '#', 'order' => 5, 'enable' => true, 'created_at' => now(), 'updated_at' => now()]);
        DB::table('menuses')->insert(['name' => 'OUTROS', 'type' => 'footer', 'value' => '#', 'order' => 6, 'enable' => true, 'created_at' => now(), 'updated_at' => now()]);


    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('menuses');
    }
}
