<?php

namespace Modules\Admin\Http\Controllers;

use Image;
use Illuminate\Http\Request;
use Modules\Users\Entities\Users;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Contracts\Support\Renderable;

class AdminProfileController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        $user = Users::first();
        
        return view('admin::profile.index',
            [
                'user' => $user
            ]
        );
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        return view('admin::create');
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('admin::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        return view('admin::edit');
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $id)
    {
        $data = $request->all();

        $name = isset($data['name']) ? $data['name'] : false;
        $email = isset($data['email']) ? $data['email'] : false;
        $image = isset($data['file']) ? $data['file'] : false;
        $username = isset($data['username']) ? $data['username'] : false;
        $password = isset($data['password']) ? $data['password'] : false;

        $user = Users::where('id', $id)->first();
        
        if($name){
            $user->name = $name;
        }
        
        if($email){
            $user->email = $email;
        }
        
        if($image){

            $imageName = time().'_'.rand(10,1000).rand(10,1000).rand(10,1000).'.'.$image->extension();  
            
            $image->move(public_path('storage/img/users'), $imageName);
        
            $image = Image::make(public_path('storage/img/users/').$imageName);
                
            if($image->width() != 1005 && $image->height() != 670){
                    
                Image::make(public_path('storage/img/users/').$imageName)->resize(null, 670,
                    function ($constraint) {
                        $constraint->aspectRatio();
                    })
                    ->resizeCanvas(1005, 670)
                    ->save(public_path('storage/img/users/').$imageName, 80);
        
            }

            $fileName = pathinfo(public_path($user->image))['filename'];

            if($fileName != 'default'){
                @unlink(public_path($user->image));
            }

            $user->image = 'storage/img/users/'.$imageName;
                
        }
        
        if($username){
            if(!empty($username)){
                $user->username = $username;
            }
        }

        if($password){
            if(!empty($password)){
                $user->password = Hash::make($password);
            }
        }
        

        $user->save();

        return redirect()->route('admin.profile.index');

  
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        //
    }
}
