

// create jaxchat container following this script
document.writeln('<div id="jaxchat" style="width:100%; height:100%; visibility:visible; overflow:hidden;"></div>');

// set the location of the jaxsettings.js
var jaxsettingsURL = 'chat/jaxsettings.js';

// start with empty user name and id
var rState = false; // read state flag for asset loading
var username = ''; // this user's name
var id = ''; // this user's id
var messages = []; // display messages array
var names = []; // display user names array
var jaxDisplayHeight = 0; // calculated display height
var jaxRefreshTimeout = null; // pointer to refresh timer
var refreshCountDown = 0.0; // countdown time decrements by refreshMSInterval
var refreshMSInterval = 200; // millisecond interval for getMessage check
var includeMessage = false; // flag to determine if getMessage will also send chat line message

// wait for document load to complete before initializing
var readyStateCheckInterval = setInterval(function() {
	if (document.readyState === "complete") {
		// clear the check interval
		clearInterval(readyStateCheckInterval);
		
		// load jaxchat javascript settings
		var s, r;
		r = false;
		s = document.createElement('script');
		s.type = 'text/javascript';
		s.src = jaxsettingsURL;
		
		// onload function to continue loading process after settings are loaded
		s.onload = s.onreadystatechange = function() {
			// check script load ready state
			if ( !rState && (!this.readyState || this.readyState === 'complete' || this.readyState === 'loaded') ) {
				// stop an further onload events for the jQuery load
				rState = true;
				
				// check to see if the jQuery library is loaded
				if (typeof jQuery === 'undefined') {
					// create a script element to load the jQuery library
					var s, r;
					r = false;
					s = document.createElement('script');
					s.type = 'text/javascript';
					s.src = jaxJquerySRCURL; // using jQuery library source from jaxsettings.js
					
					// onload function to load the JAXchat client after the jQuery library loads
					s.onload = s.onreadystatechange = function() {
						// check script load ready state
						if ( !r && (!this.readyState || this.readyState === 'complete') ) {
							// stop an further onload events for the jQuery load
							r = true;
							
							// load the JAXchat client
							jaxLoadAssets();
						}
					}; // end of jquery onload event function
					
					// append the new script element to the document body
					document.body.appendChild(s);
				}
				else {
					// jQuery library already loaded, load the JAXchat client
					jaxLoadAssets();
				}
			}
		}; // end of settings onload event function
		
		// append new script element to document body to start settings load process
		document.body.appendChild(s);
	} // end of document readstate == complete check
}, 10);


// function to load the assets, i.e. css and javascript
function jaxLoadAssets() {
	// set resource URL if not set from jaxsettings.js
	if (typeof(jaxResourceURL) === 'undefined') {
		jaxResourceURL = '';
	}

	// resources
	var resources = {
		jaxchatcss: jaxResourceURL + 'chat/css/jaxchat.css',
		jaxchatcssskin: jaxResourceURL + 'chat/css/skin-' + jaxSkin + '.css', // jaxSkin is set in jaxsettings.js
		supportjs: [
			jaxResourceURL + 'chat/js/jquery.insertatcaret.js',
			jaxResourceURL + 'chat/js/base64v1_0.js'
		]
	};

	// IE css load
	if (document.createStyleSheet) {
		document.createStyleSheet(resources.jaxchatcss);
	}
	
	// load jaxchat css
	jQuery.get(resources.jaxchatcss, function(response) {
		
		jQuery('body').prepend('<style>' + response + '</style>');
		
		// load skin style
		if (document.createStyleSheet) {
			document.createStyleSheet(resources.jaxchatcssskin);
		}
		
		jQuery.get(resources.jaxchatcssskin, function(response) {
			jQuery('body').append('<style>' + response + '</style>');
			
			jaxLoad();
		});
	});
		
	// load supporting js
	for( var si = 0; si < resources.supportjs.length; si++ ) {
		jQuery.getScript(resources.supportjs[si]);
	}
}


// function to load the JAXchat client into the web page
function jaxLoad() {
	// add the input field
	jQuery('div#jaxchat').
		append('<div id="jaxinput"></div>').
		css('font-size', jaxFontSize);
	
	// start jax input with the name input
	showNameInput();
	
	// add jax display elements
	jQuery('div#jaxchat').append('<div id="jaxmessages"></div>');
	if( showNamesColumn ) {
		jQuery('div#jaxchat').append('<div id="jaxusers"></div>');
	}
	else {
		// adjust messages element to fill chat
		jQuery('div#jaxmessages').css({'width': '99%', 'float': 'right'});
	}
	jQuery('div#jaxchat').append('<div id="jaxmessage"></div>');
	
	// calculate the available height for display
	jaxDisplayHeight = jQuery('#jaxchat').innerHeight() - jQuery('div#jaxinput').outerHeight();
	jQuery('div#jaxmessages').css('height', jaxDisplayHeight + 'px');
	jQuery('div#jaxusers').css('height', jaxDisplayHeight + 'px');
	
	
	// hide the jax message element
	jQuery('div#jaxmessage').fadeTo(0, 0);
		
	// add the input busy indicator
	jQuery('div#jaxchat').append('<img id="jaxbusyinput" src="' + jaxResourceURL + 'chat/images/ajax-loader.gif" alt="" />');
	hideBusy();
	
	// fade in the chat client
	jQuery('div#jaxchat').fadeTo(0, 0, function() {jQuery(this).css('visibility', 'visible').fadeTo(250, 1);});
	
	// start message display refresh
	getMessages(true);
}


// event function to request a user name
function requestName() {
	// get the name they selected
	var jaxUser = jQuery('input#jaxname').val();
	
	// get the last message in the current list
	var lastMessage = getLastMessage();
	
	// compile message block
	var messageData = {
		'name': jaxUser,
		'lastTime': lastMessage.time,
		'lastId': lastMessage.id
	};
	

	// send a request to use this name
	jaxRequest('requestName', messageData, function(data) {
		// error occurred then show error
		if( data.error ) {
			showMessage('<span class="jaxerror">' + data.error + '</span>');
		}
		
		// if name returned then name was accepted
		if( data.name ) {
			username = data.name;
			id = data.id;
			showChatInput();
		}
		
		// if messages returned then display
		if( data.appendMessages ) {
			// only recent appended messages returned
			messages = messages.concat(data.appendMessages.messages);
			showMessages();
			
			// clear the input
			jQuery('input#jaxchatline').val('');
		}
		
	});
}



// function to make an AJAX request to the JAXchat service
function jaxRequest(action, jaxData, callback, attemptCount) {
	showBusy();
	
	if ( typeof(attemptCount) === 'undefined' ) {
		attemptCount = 1;
	}
	
	jQuery.extend(jaxData, {'ajaxAction': action});
	
	jQuery.ajax({
		url: jaxResourceURL + 'chat/jaxchat.php',
		data: jaxData,
		dataType: "json",
		success: function (data, status) {
			hideBusy();
			
			if( callback ) {
				callback(data);
			}
		},
		error: function (data, status, e) {
			hideBusy();
			
			var errorMessage = '';
			
			if ( e === 'timeout' && attemptCount < timeoutRetryAttempts ) {
				console.log('timeout: ' + action + ' ' + attemptCount);
				attemptCount += 1;
//				showMessage('AJAX Timeout, Attempting Retry...');
				jaxRequest(action, jaxData, callback, attemptCount);
			}
			else {
				if ( e === 'timeout' ) {
					console.log('timeout failure: ' + action);
					errorMessage = 'AJAX Timeout, todas as tentativas falharam';
				}
				else {
					errorMessage = e + ' (' + data.status + ')';
				}
			
				if ( callback ) {
					callback({'error': errorMessage});
				}
				else {
					showMessage('AJAX error - ' + errorMessage);
				}
			}
		},
		timeout: refreshTimeoutSeconds * 1000
	});
}


// function to show the busy indicator
function showBusy() {
	jQuery('img#jaxbusyinput').stop().fadeTo(250, 1);
}


// function to hide the busy indicator
function hideBusy() {
	jQuery('img#jaxbusyinput').stop().fadeTo(250, 0);
}


// function to show the user name input
function showNameInput() {
	jQuery('div#jaxinput').
		html('<div class="input-group"><input class="form-control" id="jaxname" type="text" placeholder="Seu Apelido"><span class="input-group-btn"><button class="btn btn-success" id="jaxjoin" type="button"><i class="fa fa-sign-in" aria-hidden="true"></i> Entrar</button></span></div>').
		find('input').css('font-size', jaxFontSize);
	
	// join button event
	jQuery('button#jaxjoin').click(function() {
		requestName();
	});
	
	// enter on name line
	jQuery('input#jaxname').keyup(function(e) {
		// get key code
		var code = e.which || e.keyCode;
		
		// check for enter key
		if( code === 13 ) {
			// prevent this event from propagating further
			e.preventDefault();
			e.stopPropagation();
			
			requestName();
		}
	});
	
	// prevent propagation of keyup events for enter
	jQuery('input#jaxname').keyup(function(e) {
		// get key code
		var code = e.which || e.keyCode;
		
		// check for enter key
		if( code === 13 ) {
			// prevent this event from propagating further
			e.preventDefault();
			e.stopPropagation();
		}
	});
}


// function to show the chat input
function showChatInput() {
	jQuery('div#jaxinput').
		html('<div class="input-group"><input class="form-control" id="jaxchatline" type="text" placeholder="Digite uma mensagem..."><span class="input-group-btn"><button class="btn btn-success" id="jaxenviar" type="button"><i class="fa fa-share-square-o" aria-hidden="true"></i> Enviar</button></span></div>').
		find('input').css('font-size', jaxFontSize);
	
	jQuery('button#jaxenviar').click(function() {
		includeMessage = true;
		refreshCountDown = 0.0;
	});

	// enter on chat line
	jQuery('input#jaxchatline').keydown(function(e) {
		// get key code
		var code = e.which || e.keyCode;
		
		// check for enter key
		if( code === 13 ) {
			// prevent this event from propagating further
			e.preventDefault();
			e.stopPropagation();
			
			// include chat message in next get message call
			includeMessage = true;
			refreshCountDown = 0.0;
		}
		else if( code === 9 ) {
			// prevent this event from propagating further
			e.preventDefault();
			e.stopPropagation();
			
			// grab the last word in chatline
			var lastWord = /[^ ]*$/;
			var chatLine = jQuery('input#jaxchatline').val();
			chatLine = jQuery.trim(lastWord.exec(chatLine));
			
			if( chatLine.length ) {
				// create pattern based on last word
				var namePattern = new RegExp('^' + chatLine, 'i');
				
				// check for a matching name
				for(i = 0; i < names.names.length; i++) {
					// check for match against name
					if( namePattern.test(names.names[i]) ) {
						// get portion of name not in match
						var portion = names.names[i].substring(chatLine.length);
						jQuery('input#jaxchatline').insertAtCaret(portion + ' ');
						break;
					}
				}
			}
		}
	}).focus();
	
	// prevent propagation of keyup events for tab and enter
	jQuery('input#jaxchatline').keyup(function(e) {
		// get key code
		var code = e.which || e.keyCode;
		
		// check for enter key
		if( code === 13 || code === 9 ) {
			// prevent this event from propagating further
			e.preventDefault();
			e.stopPropagation();
		}
	});
}


// function to get the current messages from the server
function getMessages(firstLoad) {
	if( typeof firstLoad === 'undefined' ) {
		// not a first load, check refresh count down
		refreshCountDown -= parseFloat(refreshMSInterval) / 1000;
		if (refreshCountDown > 0) {
			// restart refresh
			startRefreshTimer();
			return false;
		}
		else {
			// reset count down
			refreshCountDown = parseFloat(refreshSeconds);
			firstLoad = false;
		}
	}
	
	// get the last message in the current list
	var lastMessage = getLastMessage();
	
	// compile message block
	var messageData = {
		'name': username,
		'id': id
	};
	
	if( firstLoad ) {
		messageData = jQuery.extend(messageData, {'getWelcome': true});
	}
	else {
		messageData = jQuery.extend(messageData, {
			'lastTime': lastMessage.time,
			'lastId': lastMessage.id
		});
	}
	
	// check to see if chat message should be included
	if (includeMessage) {
		// get user's chat message
		var d = new Date();
		messageData = jQuery.extend(messageData, {
			'message': B64.encode(jQuery('input#jaxchatline').val()),
			'messageNonce': d.getTime()
		});
		
		includeMessage = false;
	}

	// send a request to use this name
	jaxRequest('getMessages', messageData, function(data) {
		// error occurred then show error
		if( data.error ) {
			showMessage('<span class="jaxerror">' + data.error + '</span>');
		}
		
		// check for client timeout message
		if( data.timeout ) {
			showMessage('<span class="jaxerror">Tempo do limite do chat foi esgotado ou você foi banido!</span>');
			username = '';
			showNameInput();
		}
		
		// if messages returned then display
		if( data.messages ) {
			// all messages returned
			messages = data.messages.messages;
			showMessages(firstLoad);
		}
		else if( data.appendMessages && data.appendMessages.messages && data.appendMessages.messages.length ) {
			// only recent appended messages returned
			messages = messages.concat(data.appendMessages.messages);
			showMessages(firstLoad);
		}
		
		if( data.names ) {
			names = data.names;
			if( showNamesColumn ) showNames();
		}
		
		if (data.messageReceived) {
			jQuery('input#jaxchatline').val('');
		}
		
		startRefreshTimer();
	});
	
}


function startRefreshTimer() {
	stopRefreshTimer();
	jaxRefreshTimer = setTimeout(function() { getMessages(); }, refreshMSInterval);
}


function stopRefreshTimer() {
	if ( typeof jaxRefreshTimer !== 'undefined' )
	{
		clearTimeout(jaxRefreshTimer);
	}
}


// function to display the current set of messages
function showMessages(scrollToBottom) {
	if( typeof scrollToBottom === 'undefined' ) {
		scrollToBottom = false;
	}
	
	// get current scroll position
	var scrollPosition = jQuery('div#jaxmessages').scrollTop();
	if( jQuery('div#jaxmessages > ul').length ) {
		// get difference between display and messages
		var d = jQuery('div#jaxmessages > ul').outerHeight() - jaxDisplayHeight;
		if( d < 0 ) d = 0;
		if( d == scrollPosition || scrollPosition >= d - 5 ) scrollPosition = -1; // use -1 to denote that we are scrolled to the bottom
	}
	else {
		// no messages yet, assume scroll to bottom
		scrollPosition = -1;
	}
	
	// start the HTML for the message list
	messagesHTML = '<ul>';
	
	// add all the messages to the list
	for(i = 0; i < messages.length; i++) {
		messagesHTML += '<li class="';
		messagesHTML += messages[i].cssclass + '">';
		
		// get message time as integer
		var messageTime = parseInt(messages[i].time);
		
		// if is number and this message class is a user class
		if (messageTime && /user\d/.test(messages[i].cssclass)) {
			// create locale date object using message UTC seconds
			var mt = new Date(messageTime * 1000);
			
			// append time data na mensagem
			// messagesHTML += '&lt;' + zeroFill(mt.getHours(), 2) + ':' + zeroFill(mt.getMinutes(), 2) + ':' + zeroFill(mt.getSeconds(), 2) + '&gt; ';
		}
		
		messagesHTML += messages[i].message;
		messagesHTML += '</li>';
	}
	
	// end the list
	messagesHTML += '</ul>';
	
	// set the message HTML into the message container
	jQuery('div#jaxmessages').html(messagesHTML);
	
	// get difference between display and messages
	d = jQuery('div#jaxmessages > ul').outerHeight() - jaxDisplayHeight;
	if( d < 0 ) d = 0;
	
	// if scroll position was at the  end then set at new end
	if( scrollPosition === -1 || scrollToBottom ) scrollPosition = d;
	jQuery('div#jaxmessages').scrollTop(scrollPosition);
}


// function to display the current set of names
function showNames(scrollToBottom) {
	if( typeof scrollToBottom === 'undefined' ) {
		scrollToBottom = false;
	}
	
	// get current scroll position
	var scrollPosition = jQuery('#jaxusers').scrollTop();
	if( jQuery('div#jaxusers > ul').length ) {
		// get difference between display and messages
		var d = jQuery('div#jaxusers > ul').outerHeight() - jaxDisplayHeight;
		if( d < 0 ) d = 0;
		if( d == scrollPosition ) scrollPosition = -1; // use -1 to denote that we are scrolled to the bottom
	}
	
	// start the HTML for the message list


	namesHTML =  '<ul>';
	
	    // Mostrar se esta online o ninguem online
	if(names.names.length === 0){
		namesHTML += '<strong>0</strong> online';
	}else{
		namesHTML += '<strong>' + names.names.length + '</strong> online';
	}
	
	// add all the messages to the list
	for(i = 0; i < names.names.length; i++) {
		namesHTML += '<li class="' + names.classes[i] + '"><img class="chat" src="chat/images/membro.gif"> ' + names.names[i] + '</li>';
	}


	
	// end the list
	namesHTML += '</ul>';
	
	// set the message HTML into the message container
	jQuery('div#jaxusers').html(namesHTML);
	
	// get difference between display and messages
	d = jQuery('div#jaxusers > ul').outerHeight() - jaxDisplayHeight;
	if( d < 0 ) d = 0;
	
	// if scroll position was at the  end then set at new end
	if( scrollPosition === -1 || scrollToBottom ) scrollPosition = d;
	jQuery('div#jaxusers').scrollTop(scrollPosition);
	
	// get name para o chat
	//jQuery('div#jaxusers').find('li').click(function() {
	//	jQuery('input#jaxchatline').insertAtCaret(jQuery(this).html() + ' ');
	// });
}


// function to show a jax message
function showMessage(jaxMessage) {
	jQuery('div#jaxmessage').
		stop().
		html(jaxMessage).
		fadeTo(250, 1);
		setTimeout(function() { hideMessage(); }, 2000);
}


// function to hide the jax message
function hideMessage() {
	jQuery('div#jaxmessage').fadeTo(250, 0);
}


// get the last message in the current list
function getLastMessage() {
	var li = -1;
	for (var mi = 0; mi < messages.length; mi++) {
		if (messages[mi].time) li = mi;
	}
	
	if (li < 0) {
		// no messages, return an empty message
		return {'timestamp': '', 'time': null, 'id': null, 'name': '', 'message': ''};
	}
	else {
		return messages[li];
	}
}


function zeroFill(n, w) {
	w -= n.toString().length;
	if (w > 0) {
		return new Array(w + (/\./.test(n) ? 2 : 1)).join( '0' ) + n;
	}
	return n + ""; // always return a string
}
