<?php

define('ADMIN_PASSWORD', 'admin');
define('ADMIN_ENABLE', TRUE); // if set to TRUE then be sure to change the admin password
define('MAXIMUM_NAME_LENGTH', 25);
define('MAXIMUM_USER_COUNT', 100);
define('MAXIMUM_MESSAGE_LENGTH', 500);
define('CLIENT_TIMEOUT_SECONDS', 300);
define('MESSAGE_TIMEOUT_SECONDS', 60*60*24);
define('MAXIMUM_MESSAGE_HISTORY_COUNT', 100);
define('USER_CLASS_VARIATION_COUNT', 10);
define('MINIMUM_SECONDS_BETWEEN_MESSAGES', 2);
define('JAXCHAT_PATH', dirname(__FILE__) . '/');
define('JSON_FILE_PATH', JAXCHAT_PATH . 'json/'); // recommended to change json/ to a custom value
define('JAX_DEBUG', FALSE); // WARNING: disables throttling, client validation, and possibly more


// make sure the JSON path exists
if (!file_exists(JSON_FILE_PATH)) mkdir(JSON_FILE_PATH, 0755);


// using UTC time for messages
date_default_timezone_set('UTC');


// disable magic quotes
if (get_magic_quotes_gpc()) {
	$process = array(&$_GET, &$_POST, &$_COOKIE, &$_REQUEST);
	while (list($key, $val) = each($process)) {
		foreach ($val as $k => $v) {
			unset($process[$key][$k]);
			if (is_array($v)) {
				$process[$key][stripslashes($k)] = $v;
				$process[] = &$process[$key][stripslashes($k)];
			} else {
				$process[$key][stripslashes($k)] = stripslashes($v);
			}
		}
	}
	unset($process);
}


?>
