<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

/*
Route::prefix('team')->group(function() {
    Route::get('/', 'TeamController@index');
});
*/

Route::group(['middleware' => 'auth'], function () {
    Route::get('/admin/team', '\Modules\Team\Http\Controllers\TeamAdminController@index')->name('admin.team.index');
    Route::post('/admin/team/store', '\Modules\Team\Http\Controllers\TeamAdminController@store')->name('admin.team.store');
    Route::put('/admin/team/update', '\Modules\Team\Http\Controllers\TeamAdminController@update')->name('admin.team.update');
    Route::put('/admin/team/edit/{id}', '\Modules\Team\Http\Controllers\TeamAdminController@update')->name('admin.team.edit');
    Route::delete('/admin/team/delete/{id}', '\Modules\Team\Http\Controllers\TeamAdminController@destroy')->name('admin.team.destroy');
    Route::put('/admin/team/texts/update', '\Modules\Team\Http\Controllers\TeamTextsController@update')->name('admin.team.texts.update');
});
