<?php

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateStreamsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('streams', function (Blueprint $table) {
            $table->id();
            $table->longtext('player');
            $table->boolean('enable_player_popup')->default(true);
            $table->longtext('player_popup')->nullable();
            $table->boolean('enable_player')->default(true);
            $table->longtext('web_tv')->nullable();
            $table->boolean('enable_webtv')->default(true);
            $table->longtext('chat')->nullable();
            $table->boolean('enable_chat')->default(true);
            $table->longtext('current_song')->nullable();
            $table->boolean('enable_current_song')->default(true);
            
            $table->timestamps();
        });

        DB::table('streams')->insert(
            [
                'player' => '<iframe src="https://player.conectastm.com/player-barra/8146/000000" frameborder="0" width="100%" height="65"></iframe>', 
                'player_popup' => 'https://player.conectastm.com/player-popup-responsivo/8146/2', 
                'web_tv' => '<iframe class="embed-responsive-item" width="560" height="315" src="https://playerv.srvstm.com/video/alexandrejr/2/true/true/V1hwT1UyUkhVbkZTV0ZacVRUQnZlVmw2VGxOa1JYaDBWRzVhYVZWVU1Eaz0rUg==/16:9//sim/sim" frameborder="0" scrolling="no" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen=""></iframe>', 
                'chat' => '<iframe class="embed-responsive-item" width="560" height="315" src="https://player.conectastm.com/chat/8146" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen=""></iframe> ', 
                'current_song' => 'https://ssl.srvstm.com:8146/currentsong',
                'created_at' => now(), 
                'updated_at' => now()
            ]
        );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('streams');
    }
}
