<?php

namespace Modules\Statistics\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Contracts\Support\Renderable;
use Modules\Statistics\Entities\StatisticsInformations;

class StatisticsAdminController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        $enable = StatisticsInformations::first();
        $statisticsinformations = StatisticsInformations::all();
        return view('statistics::admin.index',
            [
                'statisticsinformations' => $statisticsinformations,
                'enable' => $enable->enable
            ]
        );
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        return view('statistics::create');
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('statistics::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        return view('statistics::edit');
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $type)
    {
        $data = $request->all();


        if($type == 'enable'){
            if(isset($data['enable'])){

                $enable = $data['enable'] == 'true' ? true : false;
    
                DB::table('statistics_informations')->update(['enable' => $enable]);
    
                return array(
                    'success' => true,
                    'message' => 'Alterado com sucesso'
                );
    
            }
        }else if($type == 'info'){

            $name1 = $data['name_1'];
            $value1 = $data['value_1'];
            $name2 = $data['name_2'];
            $value2 = $data['value_2'];
            $name3 = $data['name_3'];
            $value3 = $data['value_3'];

            $StatisticsInformations = StatisticsInformations::where('id', 1)->first();
            $StatisticsInformations->name = $name1;
            $StatisticsInformations->value = $value1;
            $StatisticsInformations->save();

            $StatisticsInformations = StatisticsInformations::where('id', 2)->first();
            $StatisticsInformations->name = $name2;
            $StatisticsInformations->value = $value2;
            $StatisticsInformations->save();

            $StatisticsInformations = StatisticsInformations::where('id', 3)->first();
            $StatisticsInformations->name = $name3;
            $StatisticsInformations->value = $value3;
            $StatisticsInformations->save();


            return redirect()->route('admin.statistics.index');
        }

       
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        //
    }
}
