<?php

namespace Modules\Settings\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class SettingsAdminRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'title' => [
                'required'
            ],
            'description' => [
                'required'
            ],
            'meta' => [
                'required'
            ]
        ];
    }

    public function messages(){
        return [
            'title.required' => 'O titulodo site é obrigatório',
            'description.required' => 'A descrição do site é obrigatória',
            'meta.required' => 'Metadados é obrigatório'
        ];
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }
}
