<?php

use PharIo\Manifest\Email;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->id();
            $table->string('email')->nullable();
            $table->string('title');
            $table->string('description');
            $table->string('meta');
            $table->string('smtp_name')->nullable();
            $table->string('smtp_source_email')->nullable();
            $table->string('smtp_source_return')->nullable();
            $table->string('smtp_port')->nullable();
            $table->string('smtp_host')->nullable();
            $table->string('smtp_user')->nullable();
            $table->string('smtp_password')->nullable();
            $table->string('smtp_security')->default('notls');
            $table->boolean('smtp_enable')->default(false);
            $table->string('facebook')->nullable();
            $table->string('instagram')->nullable();
            $table->string('twitter')->nullable();
            $table->string('whatsapp')->nullable();
            $table->string('tiktok')->nullable();
            $table->string('phone1')->nullable();
            $table->string('phone2')->nullable();
            $table->string('address')->nullable();
            $table->string('version')->default('1.0');
            $table->timestamps();
        });

        DB::table('settings')->insert(
            [
                'email' => 'contato@'.env('APP_DOMAIN'), 
                'title' => 'Web Rádio', 
                'description' => 'As melhores músicas você encontra aqui', 
                'meta' => 'rádio onlie, música, Diversão, entretenimento, web rádio', 
                'smtp_name' => '', 
                'smtp_source_email' => '', 
                'smtp_source_return' => '', 
                'smtp_port' => '', 
                'smtp_host' => '', 
                'smtp_user' => '', 
                'smtp_password' => '', 
                'facebook' => '', 
                'instagram' => '', 
                'twitter' => '', 
                'whatsapp' => '', 
                'tiktok' => '', 
                'phone1' => '(99) 9999-9999', 
                'phone2' => '(88) 8888-8888', 
                'address' => 'Rua 7 de Setembro', 
                'created_at' => now(), 
                'updated_at' => now()]
            );

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('settings');
    }
}
