<?php

namespace Modules\Schedule\Http\Controllers;

use stdClass;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Schedule\Entities\Schedules;
use Illuminate\Contracts\Support\Renderable;

class ScheduleAdminController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {

        if(isset($_GET['action'])){
            $action = $_GET['action'];
        }else{
            $action = false;
        }
        $schedules = new stdClass();
        $schedules->sunday = Schedules::where('day_the_week', 'sunday')->orderBy('start_time')->get();
        $schedules->monday = Schedules::where('day_the_week', 'monday')->orderBy('start_time')->get();
        $schedules->tuesday = Schedules::where('day_the_week', 'tuesday')->orderBy('start_time')->get();
        $schedules->wednesday = Schedules::where('day_the_week', 'wednesday')->orderBy('start_time')->get();
        $schedules->thursday = Schedules::where('day_the_week', 'thursday')->orderBy('start_time')->get();
        $schedules->friday = Schedules::where('day_the_week', 'friday')->orderBy('start_time')->get();
        $schedules->saturday = Schedules::where('day_the_week', 'saturday')->orderBy('start_time')->get();
        $schedules->enable = Schedules::first()->enable;

        return view('schedule::admin.index',
            [
                'schedules' => $schedules,
                'action' => $action
            ]
        );
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        return view('schedule::create');
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        $data = $request->all();

        $day_the_week = $data['day_the_week'];
        $start_time = $data['start_time'];
        $name = $data['name'];
        $presenter = $data['presenter'];
        $description = $data['description'];

        $schedule = new Schedules();
        $schedule->day_the_week = $day_the_week;
        $schedule->start_time = $start_time;
        $schedule->name = $name;
        $schedule->presenter = $presenter;
        $schedule->description  = $description;
        $schedule->save();

        return redirect()->route('admin.schedule.index');

    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('schedule::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        return view('schedule::edit');
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request)
    {
        $data = $request->all();

        if(isset($data['enable'])){

            $enable = $data['enable'] == 'true' ? true : false;

            DB::table('schedules')->update(['enable' => $enable]);

            return array(
                'success' => true,
                'message' => 'Alterado com sucesso'
            );

        }

        $id_schedule = $data['id_schedule'];
        $day_the_week = $data['day_the_week'];
        $start_time = $data['start_time'];
        $name = $data['name'];
        $presenter = $data['presenter'];
        $description = $data['description'];

        $schedule = Schedules::where('id', $id_schedule)->first();

        if(!$schedule){
            return redirect()->back();
        }
        
        $schedule->day_the_week = $day_the_week;
        $schedule->start_time = $start_time;
        $schedule->name = $name;
        $schedule->presenter = $presenter;
        $schedule->description  = $description;
        $schedule->save();

        return redirect()->route('admin.schedule.index',
            [
                'action' => $day_the_week
            ]
        );
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        $schedule = Schedules::where('id', $id)->first();

        if($schedule){
            $schedule->delete();
        }

        return redirect()->back();

    }
}
