@include('admin.header', [
   'elementActive' => 'posts'
])
<div class="content-wrapper">
    <section class="content-header">
       <h1>
          Postagens	      <small></small>
       </h1>
    </section>
    <!-- Main content -->
    <section class="content">
       <div class="row">
          <div class="col-xs-12">

            <div class="nav-tabs-custom">
                <ul class="nav nav-tabs ">
                   <li {!! $action == 'posts' || $action == false ? 'class="active"' : '' !!}>
                      <a href="#emails" data-toggle="tab">Postagens</a>
                   </li>
                   <li {!! $action == 'category' ? 'class="active"' : '' !!}>
                      <a href="#meta" data-toggle="tab">Categorias</a>
                   </li>
                   <li {!! $action == 'texts' ? 'class="active"' : '' !!}>
                        <a href="#texts" data-toggle="tab">Textos</a>
                    </li>
                </ul>
                <div class="tab-content">
                    <div id="emails" class="tab-pane {!! $action == 'posts' || $action == false ? 'active' : '' !!}">
                        <form method="post" id="form_apagar" name="form_apagar">
                            <!-- box -->
                            <div class="box">
                            <div class="box-body">
                                <div style="text-align:left;">
                                    <a href="{{ route('admin.posts.create') }}"><button type="button" class="btn btn-primary" onclick="">Nova</button></a>
                                </div>

                                <br/>

                                <form class="form-group">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" name="enable" id="enable" {{ $enable ? 'checked' : '' }} onclick="enablePosts()" id="flexCheckDefault">
                                        <label class="form-check-label" for="flexCheckDefault">
                                          Habilitar postagens
                                        </label>
                                      </div>
                                </form>

                                
                                <div id="tabela1_wrapper" class="dataTables_wrapper form-inline dt-bootstrap no-footer">
      
                                    <div class="row">
                                        <div class="col-sm-12">
                                        <table id="tabela1" class="table table-bordered table-striped dataTable no-footer" role="grid" aria-describedby="tabela1_info">
                                            <thead>
                                                <tr role="row">
                                                    <th>Titulo</th>
                                                    <th>Data</th>
                                                    <th>Grupo/Categoria</th>
                                                    <th>Destaque inicial</th>
                                                    <th>Opt.</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach ($posts as $post)
                                                    <tr role="row" class="odd">
                                                        <td style="cursor:pointer;">{{  $post->title }}</td>
                                                        <td style="cursor:pointer;">{{  $post->created_at }}</td>
                                                        <td style="cursor:pointer;">{{  $post->category }}</td>
                                                        <td style="cursor:pointer;"><input type="radio" name="emphasis" id="emphasis" {{  $post->emphasis ? 'checked' : '' }} value="{{  $post->id }}"/></td>
                                                        <td>

                                                            <a href="{{ route('admin.posts.edit', $post->id) }}"><input type="button" class="btn btn-primary" value="Editar" /></a>
                                                            <input type="button" class="btn btn-danger" value="Apagar" onclick="if (confirm('Excluir o colaborador selecionado?')) { $('#delete_{{ $post->id }}').submit(); }" />
                                                            <form action="{{ route('admin.posts.destroy', $post->id) }}" method="post" id="delete_{{ $post->id }}" hidden>
                                                                @csrf
                                                                @method('DELETE')
                                                            </form>
                        
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-12">
                                    <div class="col-12 text-right">
                                       {!! $posts->links("pagination::bootstrap-4") !!}
            
                                    </div>
                                </div>

                            </div>
                            </div>
                            <!-- /.box -->
                        </form>
                    </div>
                    <div id="meta" class="tab-pane {!! $action == 'category' ? 'active' : '' !!}">
                        <form action="#" method="post" id="form_apagar" name="form_apagar">
                            <!-- box -->
                            <div class="box">
                            <div class="box-body">
                                <div style="text-align:left;">
                                    <button type="button" class="btn btn-primary" onclick="openModalCreate();">Nova</button>                         
                                </div>
                                <hr>
                                <div id="tabela1_wrapper" class="dataTables_wrapper form-inline dt-bootstrap no-footer">
    
                                    <div class="row">
                                        <div class="col-sm-12">
                                        <table id="tabela1" class="table table-bordered table-striped dataTable no-footer" role="grid" aria-describedby="tabela1_info">
                                            <thead>
                                                <tr role="row">
                                                    
                                                    <th class="sorting" tabindex="0" aria-controls="tabela1" rowspan="1" colspan="1" aria-label="Data: activate to sort column ascending" style="width: 57px;">Nome</th>
                                                    <th class="sorting" tabindex="0" aria-controls="tabela1" rowspan="1" colspan="1" aria-label="Destaque: activate to sort column ascending" style="width: 67px;">Opt.</th>
                                                </tr>
                                            </thead>
                                            <tbody>
              
                                                @foreach ($postcategories as $postcategory)
                                                    
                                                
                                                <tr role="row" class="even">
      
                                                    <td style="cursor:pointer;">{{ $postcategory->name }}</td>
                                                    <td>

                                                        <input type="button" class="btn btn-primary" onclick="openModalEdit({{ $postcategory->id }}, '{{ $postcategory->name }}')" value="Editar" />
                                                        <input type="button" class="btn btn-danger" value="Apagar" onclick="if (confirm('Excluir o colaborador selecionado?')) { $('#delete_{{ $postcategory->id }}').submit(); }" />
                                                        <form action="{{ route('admin.categories.destroy', $postcategory->id) }}" method="post" id="delete_{{ $postcategory->id }}" hidden>
                                                            @csrf
                                                            @method('DELETE')
                                                        </form>
                    
                                                    </td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-5">
                                        <div class="dataTables_info" id="tabela1_info" role="status" aria-live="polite">Mostrando 1 a 4 de 4 registros</div>
                                        </div>
                                        <div class="col-sm-7">
                                        <div class="dataTables_paginate paging_simple_numbers" id="tabela1_paginate">
                                            <ul class="pagination">
                                                <li class="paginate_button previous disabled" id="tabela1_previous"><a href="#" aria-controls="tabela1" data-dt-idx="0" tabindex="0">&lt;&lt;</a></li>
                                                <li class="paginate_button active"><a href="#" aria-controls="tabela1" data-dt-idx="1" tabindex="0">1</a></li>
                                                <li class="paginate_button next disabled" id="tabela1_next"><a href="#" aria-controls="tabela1" data-dt-idx="2" tabindex="0">&gt;&gt;</a></li>
                                            </ul>
                                        </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            </div>
                            <!-- /.box -->
                        </form>
                    </div>
                    <div id="texts" class="tab-pane {!! $action == 'texts' ? 'active' : '' !!}">
                        <form action="{{ route('admin.poststext.update', 'texts') }}" class="form-horizontal" method="post">
                            @csrf
                            @method('PUT')
                             <fieldset>
                                <div class="form-group">
                                   <label class="col-md-12">Título</label>
                                   <div class="col-md-7">
                                      <input name="title" value="{{ $poststexts->title }}" type="text" class="form-control" >
                                   </div>
                                </div>
                             </fieldset>
                             <div>
                                <button type="submit" class="btn btn-primary">Salvar</button>
                             </div>
                          </form>
                    </div>
            </div>
          </div>
       </div>
       <!-- /.row -->
    </section>
    <!-- /.content -->
 </div>
@include('admin.footer')




<script>
    function enablePosts(){
        $('#enable').prop( "disabled", true );
        $.ajax({
            headers: {
                    'X-CSRF-Token': "{{ csrf_token() }}",
            },
            type: 'PUT',
            url: "{{ route('admin.posts.update', 0) }}",
            data: { 
                enable: $('#enable').is(':checked')
            },
            enctype: 'multipart/form-data',
            success: function(data){
                $('#enable').prop( "disabled", false );
            },
            error: function(data){
                $('#enable').prop( "disabled", false );
                console.log('Erro no Ajax !');
            }
        });
    }
    function openModalCreate(){
        $('#name').val('');

        $("#create").modal();
    }
    function openModalEdit(id, name){
        $('#id_category').val(id);
        $('#name').val(name);

        $("#update").modal();
    }
</script>

<div id="update" class="modal fade" role="dialog">
    <div class="modal-dialog modal-md">
       <!-- Modal content-->
       <div class="modal-content" id="conteudo_modal">
          <div class="modal-header">
             <button type="button" class="close" data-dismiss="modal">×</button>
             <h5 class="modal-title modal_titulo">Editar anúncio</h5>
          </div>
          <div class="modal-body" id="modal_conteudo_m">
             <style type="text/css">
                .bootstrap-timepicker-widget table{
                background-color: #fff !important;
                }
             </style>
             <form action="{{ route('admin.categories.update') }}" class="form-horizontal" method="post" enctype="multipart/form-data">
                 @csrf
                 @method('PUT')
                 <input type="text" name="id_category" id="id_category" hidden />
                <fieldset>
                   <div class="form-group">
                      <label class="col-md-12">Nome</label>
                      <div class="col-md-12">
                         <input name="name" id="name" type="text" class="form-control">
                      </div>
                   </div>
  
                   <div style="text-align: left; width: 100%;">
                      <button type="submit" class="btn btn-primary">Salvar</button>
                   </div>
                </fieldset>
             </form>
          </div>
          <div class="modal-footer">
             <button type="button" class="btn btn-default" data-dismiss="modal">Fechar</button>
          </div>
       </div>
    </div>
    </div>
<div id="create" class="modal fade" role="dialog">
    <div class="modal-dialog modal-md">
       <!-- Modal content-->
       <div class="modal-content" id="conteudo_modal">
          <div class="modal-header">
             <button type="button" class="close" data-dismiss="modal">×</button>
             <h5 class="modal-title modal_titulo">Adicionar categoria</h5>
          </div>
          <div class="modal-body" id="modal_conteudo_m">
             <style type="text/css">
                .bootstrap-timepicker-widget table{
                background-color: #fff !important;
                }
             </style>
             <form action="{{ route('admin.categories.store') }}" class="form-horizontal" method="post" enctype="multipart/form-data">
                 @csrf
                 @method('POST')
                <fieldset>
                   <div class="form-group">
                      <label class="col-md-12">Nome</label>
                      <div class="col-md-12">
                         <input name="name" id="name" type="text" class="form-control">
                      </div>
                   </div>
                   
                   <div style="text-align: left; width: 100%;">
                      <button type="submit" class="btn btn-primary">Salvar</button>
                   </div>
                </fieldset>
             </form>
          </div>
          <div class="modal-footer">
             <button type="button" class="btn btn-default" data-dismiss="modal">Fechar</button>
          </div>
       </div>
    </div>
    </div>
