<?php

namespace Modules\Posts\Http\Controllers;

Use Image;
use Illuminate\Http\Request;
use Modules\Posts\Entities\Posts;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Posts\Entities\PostCategories;
use Illuminate\Contracts\Support\Renderable;
use Modules\Posts\Entities\PostsTexts;

class PostsAdminController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        if(isset($_GET['action'])){
            $action = $_GET['action'];
        }else{
            $action = false;
        }

        $enable = Posts::first();
        $posts = Posts::paginate(9);
        $poststexts = PostsTexts::first();

        foreach($posts as $post){
            $postcategory = PostCategories::where('id', $post->id_post_category)->first();
            $post->category = $postcategory->name;
        }

        $postcategories = PostCategories::all();
        
        return view('posts::admin.index',
            [
                'posts' => $posts,
                'postcategories' => $postcategories,
                'enable' => $enable->enable,
                'action' => $action,
                'poststexts' => $poststexts
            ]
        );
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {

        $categories = PostCategories::all();

        return view('posts::admin.create',
            [
                'categories' => $categories
            ]
        );
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        $data = $request->all();

        

        $title = $data['title'];
        $content = $data['content'];
        $summary = $data['summary'];
        $author = $data['author'];

        if(isset($data['thumbnail'])){
           
            
            $image = isset($data['thumbnail']) ? $data['thumbnail'] : false;

            if($image){

                $imageName = time().'_'.rand(10,1000).rand(10,1000).rand(10,1000).'.'.$image->extension();  
            
                $image->move(public_path('storage/img/posts'), $imageName);
        
                $image = Image::make(public_path('storage/img/posts/').$imageName);
                
                if($image->width() != 600 && $image->height() != 443){
                    
                    Image::make(public_path('storage/img/posts/').$imageName)->resize(null, 443,
                    function ($constraint) {
                        $constraint->aspectRatio();
                    })
                    ->resizeCanvas(600, 443)
                    ->save(public_path('storage/img/posts/').$imageName, 80);
        
                }


                $thumbnail = 'storage/img/posts/'.$imageName;
            }else{
                $thumbnail = 'storage/img/posts/default.png';
            }
        }else{
            $thumbnail = false;
        }
        
        if(isset($data['id_post_category'])){
            $id_post_category = $data['id_post_category'];
        }else{
            $id_post_category = false;
        }

        $post = new Posts();

        $post->title = $title;
        $post->content = $content;
        $post->summary = $summary;
        $post->author = $author;

        if($thumbnail){
            $post->thumbnail = $thumbnail;
        }
        
        if($id_post_category){
            $post->id_post_category = $id_post_category;
        }

        $post->save();

        return redirect()->route('admin.posts.index', 
            [
                'active' => 'posts'
            ]
        );
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('posts::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        $categories = PostCategories::all();
        $post = Posts::where('id', $id)->first();

        return view('posts::admin.edit',
            [
                'categories' => $categories,
                'post' => $post
            ]
        );
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $id)
    {
        $data = $request->all();
        
        if(isset($data['enable'])){

            $enable = $data['enable'] == 'true' ? true : false;

            DB::table('posts')->update(['enable' => $enable]);

            return array(
                'success' => true,
                'message' => 'Alterado com sucesso'
            );

        }else{      

            $title = $data['title'];
            $content = $data['content'];
            $summary = $data['summary'];
            $author = $data['author'];

            
            $post = Posts::where('id', $id)->first();

            if(isset($data['thumbnail'])){
            
                
                $image = isset($data['thumbnail']) ? $data['thumbnail'] : false;

                if($image){

                    $imageName = time().'_'.rand(10,1000).rand(10,1000).rand(10,1000).'.'.$image->extension();  
                
                    $image->move(public_path('storage/img/posts'), $imageName);
            
                    $image = Image::make(public_path('storage/img/posts/').$imageName);
                    
                    if($image->width() != 600 && $image->height() != 443){
                        
                        Image::make(public_path('storage/img/posts/').$imageName)->resize(null, 443,
                        function ($constraint) {
                            $constraint->aspectRatio();
                        })
                        ->resizeCanvas(600, 443)
                        ->save(public_path('storage/img/posts/').$imageName, 80);
            
                    }

                    $fileName = pathinfo(public_path($post->thumbnail))['filename'];

                    if($fileName != 'default'){
                        @unlink(public_path($post->thumbnail));
                    }


                    $thumbnail = 'storage/img/posts/'.$imageName;
                }else{
                    $thumbnail = 'storage/img/posts/default.png';
                }
            }else{
                $thumbnail = false;
            }
            
            if(isset($data['id_post_category'])){
                $id_post_category = $data['id_post_category'];
            }else{
                $id_post_category = false;
            }

            $post->title = $title;
            $post->content = $content;
            $post->summary = $summary;
            $post->author = $author;

            if($thumbnail){
                $post->thumbnail = $thumbnail;
            }
            
            if($id_post_category){
                $post->id_post_category = $id_post_category;
            }

            $post->save();

            return redirect()->route('admin.posts.index', 
                [
                    'active' => 'posts'
                ]
            );
        }
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        $post = Posts::where('id', $id)->first();


        if($post){

            $fileName = pathinfo(public_path($post->thumbnail))['filename'];

            if($fileName != 'default'){
                @unlink(public_path($post->thumbnail));
            }

            $post->delete();
        }
        

        return redirect()->route('admin.posts.index',
            [
                'action' => 'posts'
            ]
        );
    }

    public function upload(Request $request){
        $data = $request->all();

        if($request->hasFile('upload')) {

            $image = isset($data['upload']) ? $data['upload'] : false;

            $imageName = time().'_'.rand(10,1000).rand(10,1000).rand(10,1000).'.'.$image->extension();  
                
            $image->move(public_path('storage/img/uploads'), $imageName);
            
            $image = Image::make(public_path('storage/img/uploads/').$imageName);
   
 
            $CKEditorFuncNum = $request->input('CKEditorFuncNum');
            $url = asset('storage/img/uploads/'.$imageName);
            $msg = 'Imagem enviada com sucesso';
            $re = "<script>window.parent.CKEDITOR.tools.callFunction($CKEditorFuncNum, '$url', '$msg')</script>";
             
            // Render HTML output
            @header('Content-type: text/html; charset=utf-8');
            echo $re;
        }
    }
}
