<?php

namespace Modules\Posts\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Posts\Entities\PostCategories;

class CategoriesAdminController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        if(isset($_GET['active'])){
            $active = 'category';
        }else{
            $active = false;
        }

        return view('posts::index',
            [
                'active' => $active
            ]
        );
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        return view('posts::create');
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        $data = $request->all();

        $name = $data['name'];

        $category = new PostCategories();
        
        $category->name = $name;

        $category->save();

        return redirect()->route('admin.posts.index',
            [
                'action' => 'category'
            ]
        );
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('posts::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        return view('posts::edit');
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request)
    {
        $data = $request->all();

        $name = $data['name'];
        $id_category = $data['id_category'];

        $category = PostCategories::where('id', $id_category)->first();
        
        $category->name = $name;

        $category->save();

        return redirect()->route('admin.posts.index',
            [
                'action' => 'category'
            ]
        );

    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        PostCategories::where('id', $id)->delete();

        return redirect()->route('admin.posts.index',
            [
                'action' => 'category'
            ]
        );
    }
}
