<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePostsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('posts', function (Blueprint $table) {
            $table->id();
            $table->string('title')->default('Vázio');
            $table->longtext('content')->nullable();
            $table->longtext('summary')->nullable();
            $table->string('author')->default('');
            $table->boolean('emphasis')->default(false);
            $table->string('thumbnail')->default('storage/img/news/default.png');
            $table->integer('id_post_category')->default(1);
            $table->integer('order')->default(1);
            $table->boolean('enable')->default(true);
            $table->timestamps();

        });
            DB::table('posts')->insert(
                [
                    'title' => 'Coronavirus no Brasil, Cuidados e Precauções que devem ser tomadas fique atento as dicas.', 
                    'summary' => 'Fique em casa vamos combater esse virus de forma responsavel.', 
                    'content' => '1. Lave bem as mãos e com frequência, usando álcool em gel ou água e sabão.
                    Por quê? Lavar as mãos com água e sabão ou usar álcool em gel mata os vírus que podem estar nas suas mãos.
                    
                     
                    
                    2. Mantenha uma distância mínima de 1 metro entre você e qualquer pessoa que tosse ou espirra.
                    Por quê? Quando alguém tosse ou espirra, gotas de fluido que podem conter o vírus são liberadas pelo nariz ou pela boca. Se você estiver muito perto, pode respirar as gotículas e, com elas, o vírus COVID-19.
                    
                     
                    
                    3. Evite tocar nos olhos, nariz e boca.
                    Por quê? As mãos tocam muitas superfícies e podem “pegar” vírus. Uma vez contaminadas, as mãos podem transferir o vírus para os olhos, nariz ou boca. A partir daí o vírus pode entrar no seu corpo e causar doenças.
                    
                     
                    
                    4. Você e as pessoas ao seu redor devem manter uma boa higiene das vias aéreas. Isso significa cobrir a boca e o nariz com o cotovelo dobrado ou com um lenço de papel quando tossir ou espirrar. O lenço usado deve ser descartado imediatamente.
                    Por quê? Os vírus se espalham através de gotículas. Ao manter uma boa higiene respiratória, você protege as pessoas ao seu redor contra vírus como resfriado, gripe e COVID-19.
                    
                     
                    
                    5. Fique em casa se não estiver bem. Se você tiver febre, tosse e falta de ar, procure atendimento médico e ligue com antecedência para o posto de saúde, UPA ou pronto-socorro.
                    Por quê? Ligar com antecedência permitirá que o seu atendimento seja direcionado rapidamente ao centro de saúde certo. Isso também irá protegê-lo e ajudar a impedir a propagação de vírus e outras infecções.
                    
                     
                    
                    6. Mantenha-se informado sobre as últimas notícias sobre a COVID-19 em canais oficiais e siga as orientações sobre como se proteger e a outras pessoas da COVID-19.
                    Por quê? Os canais oficiais terão as informações mais atualizadas sobre se a COVID-19 está se espalhando em sua área e sobre os cuidados corretos para se proteger.
                    
                     
                    
                    7. Confira as últimas notícias sobre as áreas mais perigosas (ou seja, as cidades e lugares onde a doença está se espalhando mais amplamente). Se possível, evite se deslocar para essas áreas, especialmente se você é idoso ou tem diabetes, doenças cardíacas ou pulmonares.
                    Por quê? Essas precauções devem ser tomadas nessas áreas, porque a probabilidade de contrair COVID-19 é maior.
                    
                     ', 
                    'author' => 'Governo de Santa Catarina', 
                    'emphasis' => true, 
                    'thumbnail' => 'storage/img/posts/23654657143215426561736.jpg', 
                    'id_post_category' => 1,
                    'order' => 1,
                    'created_at' => now(), 
                    'updated_at' => now()
                ]
            );

            DB::table('posts')->insert(
                [
                    'title' => 'Cazuza é reavivado com disco de músicas inéditas, documentário, show, podcasts e atualização de livro', 
                    'summary' => 'Música inédita de Cazuza será lançada para o publico.', 
                    'content' => '
                    Uma canção inédita de Cazuza acaba de ser disponibilizada para as plataformas de streaming. “Mina” é apresentada aos fãs junto de um videoclipe animado por Humberto Barros.

A composição é uma parceria com George Israel e Nilo Romero e ficou de fora da seleção de repertório do álbum Só se for a 2, de 1987.

Para a letra de “Mina”, Cazuza teve como inspiração uma confusão criada em um bar de Araxá-MG, quando o artista defendeu uma garota de um “cara que achava que era seu dono”.

Nilo lembra dessa episódio: “Saímos para comer uma pizza e a determinada altura apareceu um cara querendo mandar numa das meninas que estava ali. ‘Esse aí me viu crescer e acha que é meu dono’, ela disse. Lá pelas tantas, o cara pegou uma faca, Cazuza defendeu todo mundo, jogou uma mesa nele, o segurança chegou… Um tempo depois, veio ‘Mina\'”.

A canção, que Nilo destaca como contendo “a marca de originalidade que Cazuza de crônicas da noite ácidas, viscerais”, chegou a ser lançada por Leo Jaime, em 1990, em 2007 pelo próprio George Israel.
                    ', 
                    'author' => 'Amanda Cordeiro', 
                    'emphasis' => false, 
                    'thumbnail' => 'storage/img/posts/326517832976354065463.jpg', 
                    'id_post_category' => 1,
                    'order' => 2,
                    'created_at' => now(), 
                    'updated_at' => now()
                ]
            );

            DB::table('posts')->insert(
                [
                    'title' => 'Meta desativa contas de empresas que usavam o Facebook para espionagem', 
                    'summary' => 'Foram removidas 1.500 perfis vinculados a empresas acusadas de espionar ativistas, dissidentes e jornalistas em todo o mundo.', 
                    'content' => '
                    A Meta, empresa controladora do Facebook, anunciou nesta quinta-feira (16) que desativou cerca de 1.500 contas vinculadas a empresas acusadas de espionar ativistas, dissidentes e jornalistas em todo o mundo.

As contas suspensas do Facebook e Instagram foram vinculadas a sete empresas cujos serviços vão desde o armazenamento de informações públicas ao uso de perfis falsos para conquistar a confiança de suas vítimas e até mesmo espionagem digital através de ataques de hackers.

A Meta revelou planos para alertar cerca de 50.000 pessoas que poderiam ser alvos de espionagem em cerca de 100 países por várias empresas, incluindo algumas sediadas em Israel, líder na indústria de vigilância cibernética. A plataforma também desativou contas relacionadas em suas outras plataformas.

"Os cibermercenários frequentemente afirmam que seus serviços visam apenas criminosos e terroristas", de acordo com um comunicado da Meta.

Mas "os alvos são de fato indiscriminados e incluem jornalistas, dissidentes e críticos de regimes autoritários, famílias, membros da oposição e ativistas de direitos humanos", afirma o texto.

As empresas que vendem "serviços de inteligência na web" geralmente iniciam um processo de vigilância coletando informações disponíveis por meio de fontes públicas, como artigos de jornais e Wikipedia.

Assim, os cibermercenários criam contas falsas em várias redes sociais para coletar informações dos perfis e até mesmo participam de conversas e grupos para aprender mais sobre seus alvos, segundo pesquisadores da Meta.


                    ', 
                    'author' => 'G1', 
                    'emphasis' => false, 
                    'thumbnail' => 'storage/img/posts/546314231349793574.jpg', 
                    'id_post_category' => 1,
                    'order' => 4,
                    'created_at' => now(), 
                    'updated_at' => now()
                ]
            );
        
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('posts');
    }
}
