<?php

namespace Modules\Polls\Http\Controllers;

use Image;
use Illuminate\Http\Request;
use Modules\Polls\Entities\Polls;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Polls\Entities\PollOptions;
use Illuminate\Contracts\Support\Renderable;
use Modules\Polls\Entities\PollsTexts;

class PollsAdminController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        if(isset($_GET['active'])){
            $active = $_GET['active'];
        }else{
            $active = false;
        }

        $enable = Polls::first();
        $polls = Polls::paginate(9);

        $pollstexts = PollsTexts::first();

        foreach($polls as $poll){
            $polloptions = PollOptions::where('id_poll', $poll->id)->orderBy('total_votes', 'desc')->get();

            $poll->options = $polloptions;

        }

        return view('polls::admin.index',
            [
                'polls' => $polls,
                'enable' => isset($enable) ? $enable->enable : false,
                'active' => $active,
                'pollstexts' => $pollstexts
            ]
        );
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        return view('polls::create');
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        $data = $request->all();

        $question = $data['question'];

        $options = array();

        $options[] = isset($data['option_1']) ? $data['option_1'] : false;
        $options[] = isset($data['option_2']) ? $data['option_2'] : false;
        $options[] = isset($data['option_3']) ? $data['option_3'] : false;
        $options[] = isset($data['option_4']) ? $data['option_4'] : false;
        $options[] = isset($data['option_5']) ? $data['option_5'] : false;
        $options[] = isset($data['option_6']) ? $data['option_6'] : false;
        $options[] = isset($data['option_7']) ? $data['option_7'] : false;
        $options[] = isset($data['option_8']) ? $data['option_8'] : false;
        $options[] = isset($data['option_9']) ? $data['option_9'] : false;

        $image = isset($data['file']) ? $data['file'] : false;

        $poll = new Polls();

        if($image){

            $imageName = time().'_'.rand(10,1000).rand(10,1000).rand(10,1000).'.'.$image->extension();  
        
            $image->move(public_path('storage/img/polls'), $imageName);
    
            $image = Image::make(public_path('storage/img/polls/').$imageName);
            
            if($image->width() != 578 && $image->height() != 279){
                
                Image::make(public_path('storage/img/polls/').$imageName)->resize(null, 279,
                function ($constraint) {
                    $constraint->aspectRatio();
                })
                ->resizeCanvas(578, 279)
                ->save(public_path('storage/img/polls/').$imageName, 80);
    
            }

            $fileName = pathinfo(public_path($poll->image))['filename'];

            if($fileName != 'default'){
                @unlink(public_path($poll->image));
            }

            $poll->image = 'storage/img/polls/'.$imageName;
        }else{
            $poll->image = 'storage/img/polls/default.jpg';
        }

        $poll->question = $question;
        $poll->save();

        foreach($options as $option){
            if($option){
                $polloption = new PollOptions();
                $polloption->id_poll = $poll->id;
                $polloption->answer = $option;
                $polloption->save();
            }

        }
        
        return redirect()->route('admin.polls.index');

    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('polls::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        return view('polls::edit');
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request)
    {
        $data = $request->all();
  
        if(isset($data['active'])){
            DB::table('polls')->update(['active' => false]);
            DB::table('polls')->where('id', $data['active'])->update(['active' => true]);

            return array(
                'success' => true,
                'message' => 'Alterado com sucesso'
            );
        }else if(isset($data['enable'])){

            $enable = $data['enable'] == 'true' ? true : false;

            DB::table('polls')->update(['enable' => $enable]);

            return array(
                'success' => true,
                'message' => 'Alterado com sucesso'
            );

        }
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        $poll = Polls::where('id', $id)->first();

        if($poll){
            PollOptions::where('id_poll', $poll->id)->delete();
            $poll->delete();
        }

        return redirect()->route('admin.polls.index');
    }
}
