<?php

namespace Modules\Photos\Http\Controllers;

use Image;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Photos\Entities\Photos;
use Modules\Photos\Entities\PhotosTexts;
use Illuminate\Contracts\Support\Renderable;

class PhotosAdminController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        if(isset($_GET['active'])){
            $active = $_GET['active'];
        }else{
            $active = false;
        }

        $enable = Photos::first();
        $photos = Photos::paginate(9);
        $photostexts = PhotosTexts::first();
        
        return view('photos::admin.index',
            [
                'enable' => $enable->enable,
                'photostexts' => $photostexts,
                'photos' => $photos,
                'active' => $active
            ]
        );
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        return view('photos::create');
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        $data = $request->all();

        $name = $data['name'];
        $image = isset($data['file']) ? $data['file'] : false;

        $imageName = time().'_'.rand(10,1000).rand(10,1000).rand(10,1000).'.'.$image->extension();  
        $image->move(public_path('storage/img/photos/'), $imageName);
        $image = Image::make(public_path('storage/img/photos/').$imageName);

        if($image->width() != 1005 && $image->height() != 670){
                    
            Image::make(public_path('storage/img/photos/').$imageName)->resize(null, 670,
            function ($constraint) {
                $constraint->aspectRatio();
            })
            ->resizeCanvas(1005, 670)
            ->save(public_path('storage/img/photos/').$imageName, 80);

        }

        $photo = new Photos();

        $photo->image = 'storage/img/photos/'.$imageName;        
        $photo->name = $name;

        $photo->save();

        return redirect()->route('admin.photos.index');
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('photos::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        return view('photos::edit');
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request)
    {
        $data = $request->all();

        if(isset($data['enable'])){

            $enable = $data['enable'] == 'true' ? true : false;

            DB::table('photos')->update(['enable' => $enable]);

            return array(
                'success' => true,
                'message' => 'Alterado com sucesso'
            );

        }else if(isset($data['id_photo'])){

            $id_photo = $data['id_photo'];
            $name = $data['name'];
            $image = isset($data['file']) ? $data['file'] : false;

            $photo = Photos::where('id', $id_photo)->first();

            if($image){
        
                $imageName = time().'_'.rand(10,1000).rand(10,1000).rand(10,1000).'.'.$image->extension();  
            
                $image->move(public_path('storage/img/photos'), $imageName);
        
                $image = Image::make(public_path('storage/img/photos/').$imageName);
                
                if($image->width() != 1005 && $image->height() != 670){
                    
                    Image::make(public_path('storage/img/photos/').$imageName)->resize(null, 670,
                    function ($constraint) {
                        $constraint->aspectRatio();
                    })
                    ->resizeCanvas(1005, 670)
                    ->save(public_path('storage/img/photos/').$imageName, 80);
        
                }

                $fileName = pathinfo(public_path($photo->image))['filename'];

                if($fileName != 'default'){
                    @unlink(public_path($photo->image));
                }

                $photo->image = 'storage/img/photos/'.$imageName;
                
        
            }

            $photo->name = $name;

            $photo->save();

            return redirect()->route('admin.photos.index');
            
        }
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        $photo = Photos::where('id', $id)->first();

        if($photo){

            $fileName = pathinfo(public_path($photo->image))['filename'];

            if($fileName != 'default'){
                @unlink(public_path($photo->image));
            }

            $photo->delete();
        }

        return redirect()->back();
    }
}
