<?php

namespace Modules\Layout\Http\Controllers;

use Image;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Layout\Entities\Layouts;

class LayoutAdminController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {

        $layouts = Layouts::paginate(9);
        return view('layout::admin.index',
            [
                'layouts' => $layouts
            ]
        );
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        return view('layout::create');
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('layout::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        return view('layout::edit');
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request)
    {

        $data = $request->all();

        $id_layout = $data['id_layout'];
        $image = isset($data['file']) ? $data['file'] : false;

        $layout = Layouts::where('id', $id_layout)->first();

        $width = 250; // Largura
        $height = 250; // Altura

        if($layout->type == 'facebook' || $layout->type == 'whatsapp' || $layout->type == 'instagram'){
            $width = 250;
            $height = 250;
        }else if($layout->type == 'header'){
            $width = 500;
            $height = 100;
        }else if($layout->type == 'slide'){
            $width = 1920;
            $height = 1000;
        }

        if($image){
    
            $imageName = time().'_'.rand(10,1000).rand(10,1000).rand(10,1000).'.'.$image->extension();  
        
            $image->move(public_path('storage/img/layouts'), $imageName);
    
            $image = Image::make(public_path('storage/img/layouts/').$imageName);
            
            if($image->width() != $width && $image->height() != $height){
                
                Image::make(public_path('storage/img/layouts/').$imageName)->resize(null, $height,
                function ($constraint) {
                    $constraint->aspectRatio();
                })
                ->resizeCanvas($width, $height)
                ->save(public_path('storage/img/layouts/').$imageName, 80);
    
            }

            $fileName = pathinfo(public_path($layout->image))['filename'];

            if($fileName != 'default'){
                @unlink(public_path($layout->image));
            }

            $layout->image = 'storage/img/layouts/'.$imageName;
            
    
        }


        $layout->save();

        return redirect()->route('admin.layout.index');
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        //
    }
}
