<?php

namespace Modules\Events\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Modules\Events\Entities\Events;
use Illuminate\Contracts\Support\Renderable;
use Modules\Events\Entities\EventsTexts;

class EventsAdminController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        if(isset($_GET['active'])){
            $active = $_GET['active'];
        }else{
            $active = false;
        }

        $enable = Events::first();
        $events = Events::orderBy('id', 'desc')->paginate(9);
        $evetnstexts = EventsTexts::first();

        return view('events::admin.index',
            [
                'enable' => $enable->enable,
                'events' => $events,
                'evetnstexts' => $evetnstexts,
                'active' => $active
            ]
        );
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        return view('events::create');
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        $data = $request->all();

        $title = $data['title'];
        $description = $data['description'];

        $event = new Events();

        $event->title = $title;
        $event->description = $description;

        $event->save();

        return redirect()->route('admin.events.index');
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('events::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        return view('events::edit');
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request)
    {
        $data = $request->all();


        if(isset($data['enable'])){

            $enable = $data['enable'] == 'true' ? true : false;

            DB::table('events')->update(['enable' => $enable]);

            return array(
                'success' => true,
                'message' => 'Alterado com sucesso'
            );

        }else{
    
            $id_event = $data['id_event'];
            $title = $data['title'];
            $description = $data['description'];

            $event = Events::where('id', $id_event)->first();

            $event->title = $title;
            $event->description = $description;

            $event->save();

            return redirect()->route('admin.events.index');
        }
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        Events::where('id', $id)->delete();

        return redirect()->route('admin.events.index');
    }
}
