@include('admin.header', [
   'elementActive' => 'emails'
])

<div class="content-wrapper" style="min-height: 869px;">
    <section class="content-header">
       <h1>
          E-mails cadastrados<small>Lista de pessoas que se cadastraram para recener novidades</small>
       </h1>
    </section>
    <!-- Main content -->
    <section class="content">
       <div class="row">
          <div class="col-xs-12">
             <form action="" method="post" id="form_apagar" name="form_apagar">
                <!-- box -->
                <div class="box">
                   <div class="box-body">
                      <div>
                         <button type="button" class="btn btn-primary" onclick="openModalCreate();">Novo</button>
                         <a href="{{ route('admin.emails.export') }}"><button type="button" class="btn btn-default">Exportar</button></a>
                         <br/>
                           <br/>
                           <form class="form-group">
                              <div class="form-check">
                                 <input class="form-check-input" type="checkbox" name="enable" id="enable" {{ $enable ? 'checked' : '' }} onclick="enablePolls()" id="flexCheckDefault">
                                 <label class="form-check-label" for="flexCheckDefault">
                                    Habilitar cadastro de e-mails
                                 </label>
                                 </div>
                           </form>			         
                      </div>
 
                      <div id="tabela1_wrapper" class="dataTables_wrapper form-inline dt-bootstrap no-footer">
                         <div class="row">
                            <div class="col-sm-12">
                               <table id="tabela1" class="table table-bordered table-striped dataTable no-footer" role="grid" aria-describedby="tabela1_info">
                                  <thead>
                                     <tr role="row">
                                        
                                        <th>Nome</th>
                                        <th>E-mail</th>
                                        <th>Opt.</th>
                                     </tr>
                                  </thead>
                                  <tbody>
                                     @foreach ($emails as $email)
                                     <tr>
                                       <td>{{ $email->name }}</td>
                                       <td>{{ $email->email }}</td>
                                       <td>
                                          <input type="button" class="btn btn-primary" value="Editar" onclick="openModalEdit({{ $email->id }}, '{{ $email->name }}', '{{ $email->email }}')"/>
                                          <input type="button" class="btn btn-danger" value="Apagar" onclick="if (confirm('Excluir e-mail selecionado?')) { $('#delete_{{ $email->id }}').submit(); }" />
                                          <form action="{{ route('admin.emails.destroy', $email->id) }}" method="post" id="delete_{{ $email->id }}" hidden>
                                              @csrf
                                              @method('DELETE')
                                          </form>
  
                                      </td>
                                    </tr>
                                     @endforeach
                                     
                                  </tbody>
                               </table>
                            </div>
                         </div>
                      </div>
                      <div class="col-12">
                        <div class="col-12 text-right">
                           {!! $emails->links("pagination::bootstrap-4") !!}

                        </div>
                        </div>
                   </div>
                </div>
                <!-- /.box -->
             </form>
          </div>
       </div>
       <!-- /.row -->
    </section>
    <!-- /.content -->
 </div>

 
@include('admin.footer')



<script>
   function openModalCreate(){
       $('#id_email').val('');
       $('#name').val('');
       $("#email").val('');

       $("#create").modal();
   }
   function openModalEdit(id, name, email){
       $('#id_email').val(id);
       $('#name').val(name);
       $("#email").val(email);

       $("#update").modal();
   }
</script>

<div id="update" class="modal fade" role="dialog">
<div class="modal-dialog modal-md">
  <!-- Modal content-->
  <div class="modal-content" id="conteudo_modal">
     <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">×</button>
        <h5 class="modal-title modal_titulo">Editar usuário</h5>
     </div>
     <div class="modal-body" id="modal_conteudo_m">
        <style type="text/css">
           .bootstrap-timepicker-widget table{
           background-color: #fff !important;
           }
        </style>
        <form action="{{ route('admin.emails.update') }}" class="form-horizontal" method="post" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            <input type="text" name="id_email" id="id_email" hidden />
           <fieldset>
              <div class="form-group">
                 <label class="col-md-12">Nome</label>
                 <div class="col-md-12">
                    <input name="name" id="name" type="text" class="form-control">
                 </div>
              </div>
              <div class="form-group">
                   <label class="col-md-12">E-mail</label>
                   <div class="col-md-12">
                   <input name="email" id="email" type="text" class="form-control">
                   </div>
               </div>
              <div style="text-align: left; width: 100%;">
                 <button type="submit" class="btn btn-primary">Salvar</button>
              </div>
           </fieldset>
        </form>
     </div>
     <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Fechar</button>
     </div>
  </div>
</div>
</div>


<div id="create" class="modal fade" role="dialog">
   <div class="modal-dialog modal-md">
      <!-- Modal content-->
      <div class="modal-content" id="conteudo_modal">
         <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal">×</button>
            <h5 class="modal-title modal_titulo">Criar anúncio</h5>
         </div>
         <div class="modal-body" id="modal_conteudo_m">
            <style type="text/css">
               .bootstrap-timepicker-widget table{
               background-color: #fff !important;
               }
            </style>
            <form action="{{ route('admin.emails.store') }}" class="form-horizontal" method="post" enctype="multipart/form-data">
                @csrf
                @method('POST')
               <fieldset>
                  <div class="form-group">
                     <label class="col-md-12">Nome</label>
                     <div class="col-md-12">
                        <input name="name" id="name" type="text" class="form-control">
                     </div>
                  </div>
                  <div class="form-group">
                       <label class="col-md-12">E-mail</label>
                       <div class="col-md-12">
                       <input name="email" id="email" type="text" class="form-control">
                       </div>
                   </div>
                  <div style="text-align: left; width: 100%;">
                     <button type="submit" class="btn btn-primary">Salvar</button>
                  </div>
               </fieldset>
            </form>
         </div>
         <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal">Fechar</button>
         </div>
      </div>
   </div>
   </div>
