<?php

namespace Modules\Core\Http\Controllers;

use Illuminate\Http\Request;
use Modules\Core\Entities\Colors;
use Illuminate\Routing\Controller;
use Modules\Core\Entities\Menuses;
use Illuminate\Contracts\Support\Renderable;

class CoreAdminController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {

        if(isset($_GET['active'])){
            $active = $_GET['active'];
        }else{
            $active = false;
        }
        
        $colors = Colors::first();
        $headers = Menuses::where('type', 'header')->orderBy('order')->get();
        $footers = Menuses::where('type', 'footer')->orderBy('order')->get();
        return view('core::admin.index',
            [
                'colors' => $colors,
                'headers' => $headers,
                'footers' => $footers,
                'active' => $active
            ]
        );
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        return view('core::create');
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        // 

    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('core::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        return view('core::edit');
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $type)
    {
        $data = $request->all();

        if($type == 'header'){

            if(isset( $data['id_menu'])){
                $headers = Menuses::where('id', $data['id_menu'])->first();
                $headers->name = $data['name'];
                $headers->enable = $data['enable'] == '1' ? true : false;
                $headers->value = $data['value'];
                $headers->save();
            }

            if(isset($data['headers_order'])){
                $headers_order = json_decode($data['headers_order']);
    
                $count = 1;
        
                foreach($headers_order as $header_order){
        
                    $headers = Menuses::where('id', $header_order->id)->first();
        
                    $headers->order = $count;
                    $headers->save();
                    $count++;
                }
            }

            return redirect()->route('admin.core.index',
                [
                    'active' => 'header'
                ]
            );

        }else if($type == 'footer'){

            if(isset( $data['id_menu'])){
                $headers = Menuses::where('id', $data['id_menu'])->first();
                $headers->name = $data['name'];
                $headers->enable = $data['enable'] == '1' ? true : false;
                $headers->value = $data['value'];
                $headers->save();
            }

            if(isset($data['footers_order'])){
                $footers_order = json_decode($data['footers_order']);
    
                $count = 1;
        
                foreach($footers_order as $footer_order){
        
                    $footers = Menuses::where('id', $footer_order->id)->first();
        
                    $footers->order = $count;
                    $footers->save();
                    $count++;
                }
            }

            return redirect()->route('admin.core.index',
            [
                'active' => 'footer'
            ]
        );

        }else if($type == 'colors'){
            $colors = Colors::first();

            $colors->primary = $data['primary'];
            $colors->primary_contrast = $data['primary_contrast'];
            $colors->secondary = $data['secondary'];
            $colors->secondary_contrast = $data['secondary_contrast'];
            $colors->tertiary = $data['tertiary'];
            $colors->tertiary_contrast = $data['tertiary_contrast'];
            $colors->footer_background = $data['footer_background'];
            $colors->footer_texts = $data['footer_texts'];
            $colors->footer_titles = $data['footer_titles'];
            $colors->top_menu = $data['top_menu'];
            $colors->top_menu_selected = $data['top_menu_selected'];            
            
            $colors->save();

            return redirect()->route('admin.core.index',
            [
                'active' => 'colors'
            ]
        );
        }
        
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        //
    }
}
