<?php

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateColorsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('colors', function (Blueprint $table) {
            $table->id();
            $table->string('primary');
            $table->string('primary_contrast');
            $table->string('secondary');
            $table->string('secondary_contrast');
            $table->string('tertiary');
            $table->string('tertiary_contrast');
            $table->string('footer_background');
            $table->string('footer_texts');
            $table->string('footer_titles');
            $table->string('top_menu');
            $table->string('top_menu_selected');
            $table->timestamps();
        });

        DB::table('colors')->insert(
            [
                'primary' => '#ffcc00', 
                'primary_contrast' => '#121111', 
                'secondary' => '#ffffff', 
                'secondary_contrast' => '#171717', 
                'tertiary' => '#ff8400',
                'tertiary_contrast' => '#ffcc00',
                'footer_background' => '#1d1b21', 
                'footer_texts' => '#9ba1ac', 
                'footer_titles' => '#ffffff', 
                'top_menu' => '#ffffff', 
                'top_menu_selected' => '#ffcc00', 
                'created_at' => now(), 
                'updated_at' => now()
            ]
        );
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('colors');
    }
}
