<?php

namespace Modules\Ads\Http\Controllers;

use Image;
use Illuminate\Http\Request;
use Modules\Ads\Entities\Ads;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;

use function PHPUnit\Framework\isNull;
use Illuminate\Contracts\Support\Renderable;

class AdsAdminController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {

        if(isset($_GET['active'])){
            $active = $_GET['active'];
        }else{
            $active = false;
        }

        $ad_top = Ads::where('type', 'top')->first();
        $ad_side = Ads::where('type', 'side')->first();
        $ads = Ads::where('type', 'footer')->get();
        $enable = Ads::where('type', 'footer')->first();
        

        return view('ads::admin.index',
            [
                'ad_top' => $ad_top,
                'ad_side' => $ad_side,
                'ads' => $ads,
                'enable' => $enable,
                'active' => $active
            ]
        );
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        return view('ads::create');
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        $data = $request->all();

        $title = $data['title'];
        $url = $data['url'];
        $image = isset($data['file']) ? $data['file'] : false;

        $ad = new Ads();

        if($image){

            $imageName = time().'_'.rand(10,1000).rand(10,1000).rand(10,1000).'.'.$image->extension();  
        
            $image->move(public_path('storage/img/ads/footer'), $imageName);
    
            $image = Image::make(public_path('storage/img/ads/footer/').$imageName);
            
            if($image->width() != 474 && $image->height() != 248){
                
                Image::make(public_path('storage/img/ads/footer/').$imageName)->resize(null, 248,
                function ($constraint) {
                    $constraint->aspectRatio();
                })
                ->resizeCanvas(474, 248)
                ->save(public_path('storage/img/ads/footer/').$imageName, 80);
    
            }

            $fileName = pathinfo(public_path($ad->image))['filename'];

            if($fileName != 'default'){
                @unlink(public_path($ad->image));
            }

            $ad->image = 'storage/img/ads/footer/'.$imageName;
        }else{
            $ad->image = 'storage/img/ads/footer/default.jpg';
        }
        
        $ad->title = $title;
        $ad->url = $url;

        $ad->save();
      
        return redirect()->route('admin.ads.index');
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('ads::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        return view('ads::edit');
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $type = false)
    {
        $data = $request->all();

        $id = isset($data['id_ad']) ? $data['id_ad'] : false;
        $enable = isset($data['enable']) ? true : false;

        if($type == 'top'){
            $image = isset($data['file']) ? $data['file'] : false;
            $url = isset($data['url']) ? $data['url'] : '';

            $ad = Ads::where('id', $id)->first();

            if($image){
        
                $imageName = time().'_'.rand(10,1000).rand(10,1000).rand(10,1000).'.'.$image->extension();  
            
                $image->move(public_path('storage/img/ads/top'), $imageName);
        
                $image = Image::make(public_path('storage/img/ads/top/').$imageName);
                
                if($image->width() != 1147 && $image->height() != 143){
                    
                    Image::make(public_path('storage/img/ads/top/').$imageName)->resize(null, 143,
                    function ($constraint) {
                        $constraint->aspectRatio();
                    })
                    ->resizeCanvas(1147, 143)
                    ->save(public_path('storage/img/ads/top/').$imageName, 80);
        
                }


                $fileName = pathinfo(public_path($ad->image))['filename'];

                if($fileName != 'default'){
                    @unlink(public_path($ad->image));
                }

                $ad->image = 'storage/img/ads/top/'.$imageName;
                
        
            }
            
            $ad->enable = $enable;
            $ad->url = $url;
            $ad->save();

            return redirect()->route('admin.ads.index',
                [
                    'active' => 'top'
                ]
            );
        }else if($type == 'side'){
            $image = isset($data['file']) ? $data['file'] : false;
            $url = isset($data['url']) ? $data['url'] : '';

            $ad = Ads::where('id', $id)->first();

            if($image){
        
                $imageName = time().'_'.rand(10,1000).rand(10,1000).rand(10,1000).'.'.$image->extension();  
            
                $image->move(public_path('storage/img/ads/side'), $imageName);
        
                $image = Image::make(public_path('storage/img/ads/side/').$imageName);
                
                if($image->width() != 434 && $image->height() != 144){
                    
                    Image::make(public_path('storage/img/ads/side/').$imageName)->resize(null, 144,
                    function ($constraint) {
                        $constraint->aspectRatio();
                    })
                    ->resizeCanvas(434, 144)
                    ->save(public_path('storage/img/ads/side/').$imageName, 80);
        
                }


                $fileName = pathinfo(public_path($ad->image))['filename'];

                if($fileName != 'default'){
                    @unlink(public_path($ad->image));
                }

                $ad->image = 'storage/img/ads/side/'.$imageName;
                
        
            }
            
            $ad->enable = $enable;
            $ad->url = $url;
            $ad->save();

            return redirect()->route('admin.ads.index',
                [
                    'active' => 'side'
                ]
            );
        }else if($type == 'footer'){

            $title = $data['title'];
            $url = $data['url'];
            $image = isset($data['file']) ? $data['file'] : false;

            $ad = Ads::where('id', $id)->first();

            if($image){

                $imageName = time().'_'.rand(10,1000).rand(10,1000).rand(10,1000).'.'.$image->extension();  
            
                $image->move(public_path('storage/img/ads/footer'), $imageName);
        
                $image = Image::make(public_path('storage/img/ads/footer/').$imageName);
                
                if($image->width() != 474 && $image->height() != 248){
                    
                    Image::make(public_path('storage/img/ads/footer/').$imageName)->resize(null, 248,
                    function ($constraint) {
                        $constraint->aspectRatio();
                    })
                    ->resizeCanvas(474, 248)
                    ->save(public_path('storage/img/ads/footer/').$imageName, 80);
        
                }

                $fileName = pathinfo(public_path($ad->image))['filename'];

                if($fileName != 'default'){
                    @unlink(public_path($ad->image));
                }

                $ad->image = 'storage/img/ads/footer/'.$imageName;
            }
            $ad->title = $title;
            $ad->url = $url;

            $ad->save();
      
            return redirect()->route('admin.ads.index',
                [
                    'active' => 'footer'
                ]
            );

        }else if($type == 'enable'){

            if(isset($data['enable'])){

                $enable = $data['enable'] == 'true' ? true : false;

                DB::table('ads')->where('id', '!=', 1)->update(['enable' => $enable]);

                return array(
                    'success' => true,
                    'message' => 'Alterado com sucesso'
                );

            }
        }
        
       
        
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        $ad = Ads::where('id', $id)->first();

        if($ad){

            $fileName = pathinfo(public_path($ad->image))['filename'];

            if($fileName != 'default'){
                @unlink(public_path($ad->image));
            }

            $ad->delete();
        }

        return redirect()->back();
    }
}
