<?php

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAdsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ads', function (Blueprint $table) {
            $table->id();
            $table->string('title')->default('Ads');
            $table->string('url')->default('');
            $table->string('image')->default('');
            $table->string('type')->default('footer');
            $table->boolean('enable')->default(true);
            $table->timestamps();
        });

        DB::table('ads')->insert(['title' => 'Anúncio', 'type' => 'top', 'image' => 'storage/img/ads/top/default.gif', 'created_at' => now(), 'updated_at' => now()]);
        DB::table('ads')->insert(['title' => 'Anúncio', 'type' => 'side', 'image' => 'storage/img/ads/side/default.gif', 'created_at' => now(), 'updated_at' => now()]);
        DB::table('ads')->insert(['title' => 'Anúncio 1', 'type' => 'footer', 'image' => 'storage/img/ads/footer/default.jpg', 'created_at' => now(), 'updated_at' => now()]);
        DB::table('ads')->insert(['title' => 'Anúncio 2', 'type' => 'footer', 'image' => 'storage/img/ads/footer/default.jpg', 'created_at' => now(), 'updated_at' => now()]);
        DB::table('ads')->insert(['title' => 'Anúncio 3', 'type' => 'footer', 'image' => 'storage/img/ads/footer/default.jpg', 'created_at' => now(), 'updated_at' => now()]);
        DB::table('ads')->insert(['title' => 'Anúncio 4', 'type' => 'footer', 'image' => 'storage/img/ads/footer/default.jpg', 'created_at' => now(), 'updated_at' => now()]);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ads');
    }
}
